#ifndef HOLDING_HPP
#define HOLDING_HPP

#include <iostream>

using namespace std;

class Holding {
private:
    int userId;
    int assetId;
    double amount;      
    double avgCost;     

public:
    // Constructor per defecte

    // PRE: cert
    // POST: Crea un Holding amb valors per defecte
    Holding();
    
    // Constructor 

    // PRE: userId > 0, assetId > 0, amount >= 0, avgCost >= 0
    // POST: Crea un Holding amb els valors donats
    Holding(int userId, int assetId, double amount, double avgCost);
    
    // Destructor

    // PRE: cert
    // POST: Elimina els recursos de Holding
    ~Holding();
    
    // Consultors

    // PRE: cert
    // POST: Retorna el userId
    int getUserId() const;
    
    // PRE: cert
    // POST: Retorna el assetId
    int getAssetId() const;
    
    // PRE: cert
    // POST: Retorna la quantitat d'unitats
    double getAmount() const;
    
    // PRE: cert
    // POST: Retorna el precio mitjà de compra
    double getAvgCost() const;
    
    // PRE: quantity > 0, priceUnit > 0
    // POST: Incrementa amount i recalcula avgCost
    void buy(double quantity, double priceUnit);
    
    // PRE: quantity > 0
    // POST: Si amount es negatiu, ho converteix en 0, Si amount queda en 0, avgCost = 0
    void sell(double quantity);
    
    // PRE: currentPrice >= 0
    // POST: Retorna amount * currentPrice
    double getCurrentValue(double currentPrice) const;
    
    // PRE: currentPrice >= 0
    // POST: Retorna amount * currentPrice - amount * avgCost
    double getProfit(double currentPrice) const;

};

#endif
