#include "Holding.hpp"
#include <iostream>
#include <stdexcept>

using namespace std;

// Constructor per defecte

// PRE: cert
// POST: Crea un Holding amb valors per defecte
Holding::Holding() : userId(0), assetId(0), amount(0.0), avgCost(0.0) {}

// Constructor 

// PRE: userId > 0, assetId > 0, amount >= 0, avgCost >= 0
// POST: Crea un Holding amb els valors donats
Holding::Holding(int userId, int assetId, double amount, double avgCost) {
    
    this->userId = userId;
    this->assetId = assetId;
    this->amount = amount;
    this->avgCost = avgCost;
}

// Destructor

// PRE: cert
// POST: Elimina els recursos de Holding
Holding::~Holding() {}

// Consultors

// PRE: cert
// POST: Retorna el userId
int Holding::getUserId() const {
    return userId;
}


// PRE: cert
// POST: Retorna el assetId
int Holding::getAssetId() const {
    return assetId;
}


// PRE: cert
// POST: Retorna la quantitat d'unitats
double Holding::getAmount() const {
    return amount;
}


// PRE: cert
// POST: Retorna el precio mitjà de compra
double Holding::getAvgCost() const {
    return avgCost;
}


// PRE: quantity > 0, priceUnit > 0
// PoOST: Incrementa amount i recalcula avgCost
void Holding::buy(double quantity, double priceUnit) {
    
    double oldAmount = this->amount;
    double oldAvg = this->avgCost;
    
    
    double newAmount = oldAmount + quantity;
    
    
    
    double newAvg = (oldAmount * oldAvg + quantity * priceUnit) / newAmount;
    
    this->amount = newAmount;
    this->avgCost = newAvg;
}


// PRE: quantity > 0
// POST: Si amount es negatiu, ho converteix en 0, Si amount queda en 0, avgCost = 0
void Holding::sell(double quantity) {
    
    
    this->amount -= quantity;
    
    
    if (this->amount < 0) {
        this->amount = 0;
    }
    
    
    if (this->amount == 0) {
        this->avgCost = 0;
    }
}


// PRE: currentPrice >= 0
// POST: Retorna amount * currentPrice
double Holding::getCurrentValue(double currentPrice) const {
    
    return amount * currentPrice;
}


// PRE: currentPrice >= 0
// POST: Retorna amount * currentPrice - amount * avgCost
double Holding::getProfit(double currentPrice) const {
    
    return amount * currentPrice - amount * avgCost;
}
