#ifndef ASSET_HPP
#define ASSET_HPP

#include <string>
#include <vector>
#include <iostream>
#include "Price.hpp"

using namespace std;

class Price;

class Asset {
private:
    static int nextId;
    int id;
    string assetSymbol;
    string name;
    int num_decimals;
    vector<Price> vec_prices;

public:
    // Constructor

    // PRE: assetSymbol no buit, name valid, num_decimals entre [0,18]
    // POST: Crea un Asset amb els paràmetres donats
    Asset(const string& symbol, const string& name, int decimals);
    
    // Destructor

    //PRE: cert
    //POST: Elimina l'actiu
    ~Asset();
    
    // Consultors

    //PRE: cert
    //POST: retorna el id del actiu
    int getId() const;
    //PRE: cert
    //POST: retorna el simbol del actiu
    string getAssetSymbol() const;
    //PRE: cert
    //POST: retorna el nom del actiu
    string getName() const;
    //PRE: cert
    //POST: retorna el numero de decimals del actiu
    int getNumDecimals() const;
    //PRE: cert
    //POST: retorna el vector de preus dels actius
    const vector<Price>& getPrices() const;
    
    // Modificadors

    // Pre: Price vàlid
    // Post: Afegeix un preu al vector de preus
    void addPrice(const Price& price);
    
    //PRE: cert
    //POST: visualitza les dades del p.i.
    friend ostream& operator<<(ostream& os, const Asset& asset);
};

#endif
