#include "Asset.hpp"
#include <iostream>
#include <stdexcept>

using namespace std;

int Asset::nextId = 1;

// Constructor

// PRE: assetSymbol no buit, name valid, num_decimals entre [0,18]
// POST: Crea un Asset amb els paràmetres donats
Asset::Asset(const string& symbol, const string& name, int decimals) {
    
    this->id = nextId++;
    this->assetSymbol = symbol;
    this->name = name;
    this->num_decimals = decimals;
}

//Destructor

//PRE: cert
//POST: Elimina l'actiu
Asset::~Asset() {
}

//PRE: cert
//POST: retorna el id del actiu
int Asset::getId() const {
    return id;
}
//PRE: cert
//POST: retorna el simbol del actiu
string Asset::getAssetSymbol() const {
    return assetSymbol;
}
//PRE: cert
//POST: retorna el nom del actiu
string Asset::getName() const {
    return name;
}
//PRE: cert
//POST: retorna el numero de decimals del actiu
int Asset::getNumDecimals() const {
    return num_decimals;
}
//PRE: cert
//POST: retorna el vector de preus dels actius
const vector<Price>& Asset::getPrices() const {
    return vec_prices;
}
// Pre: Price vàlid
// Post: Afegeix un preu al vector de preus
void Asset::addPrice(const Price& price) {
    vec_prices.push_back(price);
}

//Operacions escriptura

//PRE: cert
//POST: visualitza les dades del p.i.
ostream& operator<<(ostream& os, const Asset& asset) {
    os << asset.assetSymbol << " - " << asset.name << " - Decimals: " << asset.num_decimals;
    return os;
}
