#ifndef ADDRESS_HPP
#define ADDRESS_HPP

#include <string>
#include <iostream>

using namespace std;

class Address {
private:
    int id;
    int userId;
    string assetSymbol;
    string address;
    string label;
    
    static int nextId;

public:
    // Constructor

    // PRE: userId vàlid, assetSymbol no buit, address no buida, label valid
    // POST: Crea una Address amb els paràmetres donats
    Address(int userId, const string& asset, const string& addr, const string& labelDesc);
    
    // Destructor

    //PRE: cert
    //POST: Elimina l'adreça
    ~Address();
    
    // Consultors

    // PRE: cert
    // POST retorna l'id de l'adreça
    int getId() const;
    
    // PRE: cert
    // POST retorna l'id de l'usuari
    int getUserId() const;
    
    // PRE: cert
    // POST: retorna el símbol de l'actiu
    string getAssetSymbol() const;
    
    // PRE: cert
    // POST: retorna l'adreça
    string getAddress() const;
    
    // PRE: cert
    // POST: retorna la descripció/etiqueta
    string getLabel() const;
    
    //Operacions escriptura

    //PRE: cert
    //POST: visualitza les dades del p.i.
    friend ostream& operator<<(ostream& os, const Address& a);
};

#endif
