#include "Address.hpp"
#include <stdexcept>
#include <iostream>

using namespace std;

int Address::nextId = 1;

// Constructor

// PRE: userId vàlid, assetSymbol no buit, address no buida, label valid
// POST: Crea una Address amb els paràmetres donats
Address::Address(int userId, const string& asset, const string& addr, const string& labelDesc) {
    
    this->id = nextId++;
    this->userId = userId;
    this->assetSymbol = asset;
    this->address = addr;
    this->label = labelDesc;
}

// Destructor

//PRE: cert
//POST: Elimina l'adreça
Address::~Address() 
{
}

// Consultors

// PRE: cert
// POST: retorna l'id de l'adreça
int Address::getId() const {
    return id;
}

// PRE: cert
// POST: retorna l'id de l'usuari
int Address::getUserId() const {
    return userId;
}

// PRE: cert
// POST: retorna el símbol de l'actiu
string Address::getAssetSymbol() const {
    return assetSymbol;
}

// PRE: cert
// POST: retorna l'adreça
string Address::getAddress() const {
    return address;
}

// PRE: cert
// POST: retorna la descripció/etiqueta
string Address::getLabel() const {
    return label;
}

//Operacions escriptura

//PRE: cert
//POST: visualitza les dades del p.i.
ostream& operator<<(ostream& os, const Address& a) {
    os << a.assetSymbol << " - " << a.address << " - " << a.label;
    return os;
}
