# Mètode per a l'eliminació d'usuari a gestor de carteres cripto.

Implementa el mètode `deleteUser` a la classe `CryptoApp`. Aquest mètode
ha de gestionar l'eliminació completa d'un usuari del sistema,
assegurant que no quedin dades inconsistents (\"orfes\"). Utilitzeu
l'arxiu `CryptoApp.cpp` i implementeu el mètode
`void CryptoApp::deleteUser(const string& name)` situat al final de
l'arxiu. Haureu de:

1.  Descarregar els arxius públics.

2.  Canviar el nom de `CryptoApp_old.cpp` a `CryptoApp.cpp`.

3.  Implementar el codi del mètode `deleteUser`:

        // PRE: name és el nom d'usuari a eliminar
        // POST: Si l'usuari existeix, elimina l'usuari i tots els seus 
        //       holdings associats de manera eficient. Si no, no fa res.
        void CryptoApp::deleteUser(const string& name) 
        {
        }

4.  Comprimir en format .tar l'arxiu `CryptoApp.cpp`.

        tar -cvf CryptoApp.tar CryptoApp.cpp

5.  Pujar l'arxiu .tar a Jutge amb la funció implementada.

**ESPECIFICACIONS:**

1.  **Entrada:** Rep el nom de l'usuari (`string`) (ex: `jaume`).

2.  **Context:** La classe disposa de mètodes interns que pot consultar.
    Per exemple, per buscar si un usuari existeix i la seva posició en
    `vec_users`, pot utilitzar:

    ::: center
    `int findUserIndexByName(string name)`
    :::

3.  **Validació:** Si l'usuari no existeix, la funció no ha d'eliminar
    res.

4.  **Esborrat en Cascada:** Abans d'eliminar l'usuari, ha d'eliminar
    totes les tinences (*Holdings*) vinculades a aquest usuari del
    vector `vec_holdings`.

5.  **Esborrat de l'Usuari:** Finalment, elimini l'usuari del vector
    `vec_users`.

**Observacions:**

- **Els vectors `vec_users` i `vec_holdings` es relacionen mitjançant
  l'`userID` (`int`), no pel nom.**

- Ha d'obtenir primer l'ID de l'usuari per poder buscar els seus
  corresponents *holdings*.

**Requisits de Rendiment (Important):**

- El sistema pot contenir desenes de milers de *Holdings*.

- Es valorarà l'eficiència algorítmica en l'eliminació de les tinences
  *holdings*.

**Nota:** L'ordre dels elements en `vec_holdings` **NO** és rellevant i
pot alterar-se durant l'esborrat. L'ordre en `vec_users` sí que s'ha de
mantenir.

**API DE CLASSES AUXILIARS**

- **User**

  - `int getId()` --- Retorna l'ID únic de l'usuari.

  - `string getName()` --- Retorna el nom de l'usuari.

- **Asset**

  - `int getId()` --- Retorna l'ID únic de l'actiu.

  - `string getAssetSymbol()` --- Retorna el símbol (ex: \"ETH\").

- **Holding**

  - `int getUserId()` --- Retorna l'ID de l'usuari propietari.

  - `int getAssetId()` --- Retorna l'ID de l'actiu.

**DOCUMENTACIÓ DE REFERÈNCIA DE LA CLASSE VECTOR**\

Utilitzi aquesta informació per seleccionar les operacions més adequades
segons els requisits d'eficiència.

- `v[i]` --- Eficiència: $O(1)$

  - Accedeix a l'element en la posició `i`. Permet lectura i escriptura.

  - Exemple: `int x = v[0];`, `v[2] = 10;`

- `v.back()` --- Eficiència: $O(1)$

  - Retorna una referència directa a l'últim element del vector.

  - Exemple accedir: `cout << v.back().getName();`

  - Exemple sobreescriure: `v.back() = objX;`

- `v.push_back(val)` --- Eficiència: $O(1)$

  - Afegeix una còpia de l'element `val` al final del vector. Augmenta
    la mida en 1.

  - Exemple: `v.push_back(usuari);`

- `v.pop_back()` --- Eficiència: $O(1)$

  - Crida al destructor de l'ultim element i l'elimina del vector.
    Redueix la mida en 1.

  - Exemple: `v.pop_back();`

- `v.erase(it)` --- Eficiència: $O(N)$

  - Crida al destructor de l'element apuntat per l'iterador i l'elimina
    del vector. Desplaça tots els elements posteriors a l'esquerra.

  - Exemple esborrar element amb índex 2: `v.erase(v.begin() + 2);`

- `v.size()` --- Eficiència: $O(1)$

  - Retorna el nombre d'elements actuals.

  - Exemple: `v.size();`

## Entrada

Com a entrada hi haurà els comandaments de creació d'usuaris, actius i
holdings, finalitzant amb la crida a `deleteUser`.

## Sortida

El programa principal realitzarà una comprovació automàtica \"Abans i
Després\":

1.  Imprimirà si existeix l'usuari \[0,1\] i quants *holdings* té \[0,
    1, \..., N\] (ex: `1 3`).

2.  Executarà la funció implementada.

3.  Imprimirà si l'usuari existeix \[0,1\] i quants *holdings* té amb
    aquest ID (si s'ha eliminat correctament: `0 0`)

## Informació del problema

Autoria: Jaume Gallego

Generació: 2026-01-25T21:09:35.677Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
