# Examen práctica - Turno 2 - Problema 1 - Es código?

1.  El peso de este ejercicio en la nota del exámen de la práctica es de
    un 33.33% (1/3 de la nota).

2.  La evaluación es completamente automática (nota manual: 0%, nota
    automática: 100%)

3.  El peso de los juegos de pruebas público y privado en el cálculo de
    la nota automática es idéntico (público: 5/10, privado: 5/10).

Dado un arbol de códigos $t$ y un string $s$ de 0's y 1's queremos un
procedimiento

    void es_codigo(const BinTree< pair<string,int> >& t, const string& s, 
                   int& res, string& codif);

que retorna con `res == -1` si $s$ un prefijo del código de algún
símbolo en el "treecode" $t$ pero no un código, retorna con `res == 0`
si $s$ es el código de algún símbolo en $t$, y retorna con `res == 1` si
existe un código en $t$ que es un prefijo de $s$ pero $s$ no es un
código. Además, si `res == 0` entonces en `codif` se devuelve el símbolo
codificado por $s$, y en caso contrario se retorna con `codif == "**"`.
Informalmente, `res==0` si $s$ es un código en $t$, `res==-1` si $s$ es
"demasiado corto" y `res==1` si $s$ es "demasiado largo".

![image](treecode.png){width="4cm"}

Por ejemplo, en el árbol $t$ de la figura los símbolos codificados son
a, b, c, d, e y sus códigos respectivos son `11`, `100`, `00`, `101` y
`01`. Por lo tanto `es_codigo(t, s, res, codif)` retornará con `res==0`
y `codif=="c"` si $s=\texttt{"00"}$. Si $s=\texttt{"1001"}$ entonces el
procedimiento retornará con `res==1` y si $s=\texttt{"10"}$ entonces
retornará con `res==-1`. En estos dos últimos casos `codif == "**"` ya
que en ambos tenemos `res != 0`).

Se os suministra un módulo (ficheros `treecodeIO.cc` y `treecodeIO.hh`)
con las operaciones de entrada/salida de "treecodes". Con todo ello
escribiréis un pequeño programa que lee una serie de casos, cada caso
formado por un "treecode" y una secuencia de strings binarios e imprime,
para cada caso, si los strings son códigos o no, y cúal es el símbolo
codificado, en su caso.

## Entrada

La entrada consiste en una serie de casos. Para cada caso se da una
secuencia en formato válido que representa a un "treecode" (se puede
leer usando la función `leer_treecode` que os proporcionamos); si el
treecode no es vacío, después del "treecode" viene un valor entero
$k\ge 0$ y a continuación una secuencia de $k$ strings binarios (esto
es, sólo contienen 0s y 1s).

La secuencia de casos termina con un "treecode" vacío, siendo todos los
casos precedentes "treecodes" que codifican 2 símbolos o más.

## Salida

Para cada caso, si el "treecode" leído no es vacío, se imprime el valor
$k$, seguido de $k$ ternas, formada cada una por el correspondiente
string $s$ dado, seguido del resultado `res` (-1, 0 o 1) y el valor del
string `codif` (es decir, el símbolo codificado por $s$ si `res == 0` o
`"**"` si `res != 0`).

La salida de cada caso acaba con un salto de línea.

## Información del problema

Autoría: Profesores de PRO2

Generación: 2026-01-25T15:19:23.704Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
