# Jugadors de bàsquet

Ens donen una llista de jugadors de bàsquet d'entrada. Per a cada
jugador ens donen el seu nom (un string), el seu salari (un natural), i
el nombre de punts que han fet durant la temporada (un natural). Aquesta
llista ens la donen ordenada de menys a més punts. Per exemple, ens
poden donar la llista:

    McDaniel 210 1520
    Pipen 198 2348
    Bird 412 3213
    Johnson 328 4532
    Jordan 563 6312

Fixeu-vos que `Jordan` apareix en últim lloc perquè el seu nombre de
punts (6312) és el màxim.

També ens donen una parella de valors enters $[p_1,p_2]$, que representa
un interval de punts. Hem de considerar els jugadors que tenen un nombre
de punts dins de l'interval $[p_1,p_2]$, calcular la suma dels seus
salaris, i escriure els noms d'aquests jugadors (en el mateix ordre de
la llista).

Seguint amb l'exemple, suposeu que ens donen l'interval $[2005,5479]$.
Fixeu-vos que els jugadors `Pipen, Bird i Johnson` són els que apareixen
a la llista (en aquest ordre) amb un nombre de punts major o igual a
$2005$ i menor o igual a $5479$. Llavors hauriem d'escriure la suma dels
seus salaris i els seus noms:

    938 Pipen Bird Johnson

Per a resoldre aquest exercici, és obligatori usar la següent declaració
i implementar i usar convenientment les següents funcions:

    struct Jugador {
        string nom;
        int salari;
        int punts;
    };

    typedef vector<Jugador> Jugadors;

    // Llegeix el nom, el salari i els punts d'un jugador de l'entrada estandar,
    // crea el jugador amb aquestes dades i el retorna.
    Jugador llegirJugador();

    // Retorna cert sii el jugador que és rep com a paràmetre té un nombre de punts
    // dins de l'interval [p1,p2].
    bool pertanyAInterval(const Jugador &jugador, int p1, int p2);

## Entrada

La primera línia de l'entrada té un natural $n$, el nombre de jugadors.
Després venen $n$ línies, on cadascuna descriu un jugador, amb el nom
(un string de lletres majúscules i minúscules i dígits), el salari (un
natural) i el nombre de punts de la temporada (un natural). Després
tenim una nova línia amb un natural positiu $m$, el nombre de casos
d'intervals. Després tenim $m$ línies, on cadascuna té dos naturals
$p_1,p_2$, que cumpleixen $p_1\leq{}p_2$ i descriuen un interval de
punts $[p_1,p_2]$.

## Sortida

Per a cadascun dels $m$ casos $[p_1,p_2]$, s'ha d'escriure una línia.
Aquesta línia conté, en primer lloc, la suma dels salaris dels jugadors
que tenen un nombre de punts dins de l'interval $[p_1,p_2]$. Després, la
línia conté els noms d'aquests mateixos jugadors en el mateix ordre de
la llista.

## Observació

De cara a superar els jocs de proves públics i obtenir una bona nota (8
sobre 10 com a molt) n'hi ha prou amb que feu una implementació senzilla
basada en cerques i recorreguts bàsics. Ara bé, els jocs de proves
privats són grans ($n$ i $m$ són grans, tot i que el nombre de jugadors
dins de cada interval demanat és petit en aquests jocs de proves
privats). Per tant, si voleu aspirar a superar tots els jocs de proves
privats i obtenir la màxima nota haureu d'implementar un esquema de
cerca més eficient.

## Informació del problema

Autoria: FOPR

Generació: 2026-01-25T15:13:04.502Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
