# Practica de PRO2 - Otoño 2019 - entrega final definitiva

Este problema corresponde a la entrega **final definitiva** de la
práctica; además del código C++ de la práctica, es necesario entregar la
documentación Doxygen, y en su caso el juego de pruebas preparado para
la competencia transversal de Trabajo en Equipo. Los juegos de pruebas
públicos y privados en esta entrega son los **definitivos**, los mismos
que en la entrega final provisional.

Este problema es el único canal disponible para realizar la entrega
definitiva de la práctica y también la entrega de los materiales para
evaluar la competencia transversal de Trabajo en Equipo. Tened en cuenta
que

- Esta es la entrega que dará lugar a la mayor parte de la nota de la
  práctica (90%); la nota de la entrega tendrá una parte procedente de
  corrección automática y otra procedente de corrección manual

- No superar ningún juego de pruebas conllevará un cero en la nota de la
  entrega

- En esta entrega pedimos más cosas, que detallamos a continuación en
  negrita, además del código de la práctica y el Makefile, que se pedían
  en la entrega provisional

- Recomendamos usar el problema de la entrega provisional para probar el
  código hasta tener totalmente acabada la práctica

## Entrada

Una secuencia de instrucciones y datos que siguen el formato del
enunciado de la práctica y del juego de pruebas público.

## Salida

Una secuencia de resultados que siguen el formato del enunciado de la
práctica y del juego de pruebas público.

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: juego de pruebas que ensaya principalmente las
  funcionalidades de la entrega intermedia (funciones 1--14)

- privat2: juego de pruebas que hace énfasis en las funcionalidades de
  búsqueda por fecha y por etiqueta (funciones 15--16)

- privat3: juego de pruebas que hace énfasis en las funcionalidad de
  consultas booleanas (función 17)

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros `.hh` y `.cc` de las clases y el programa principal que
  habéis implementado, **convenientemente documentados mediante
  Doxygen**.

- El fichero `Makefile`, que usaremos para generar y probar el
  ejecutable

- **Un fichero `html.zip`, que se obtiene "zipeando" la carpeta `html`
  generada por Doxygen a partir de los `.cc` y `.hh` de los módulos. La
  documentación en Doxygen no solo ha de explicar la parte pública de
  las clases (como en la entrega de la especificación): también ha de
  documentarse la parte privada (atributos y métodos privados) y la
  implementación de métodos públicos, privados y funciones auxiliares.**

- **Para la competencia transversal de Trabajo en Equipo, un único
  integrante designado de cada equipo ha de entregar un fichero `.zip`
  con el trabajo en equipo realizado siguiendo las instrucciones que se
  detallan en el documento sobre la competencia transversal de Trabajo
  en Equipo en la página web de PRO2.**

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El `Makefile` ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

- **Si no se entrega la documentación generada por el Doxygen, o ésta es
  incompleta (por ejemplo, si no se ven los elementos privados o la
  implementación de todas las operaciones), la nota de la corrección
  manual será cero. Comprobad que vuestra documentación es correcta
  antes de la entrega. Es necesario usar un Doxyfile basado en el de la
  sesión 10 de laboratorio para generar correctamente la
  documentación**.

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make tar`.

    ---- Fichero Makefile ---------------------------------------

    ...
    clean:
        rm *.o
        ...
    tar: 
        tar -cvf practica.tar Makefile *.cc *.hh html.zip ...
    ...

Con eso reduciréis el riesgo de error al hacer las entregas. El Jutge no
acepta `.tar` donde los ficheros estén dentro de carpetas. Recomendamos
usar `GNU tar` para reducir el riesgo de que el fichero `practica.tar`
sea incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

Si habéis utilizado `PRO2Excepcio.hh`, que no es obligatorio, si que es
imprescindible incluirlo en vuestra entrega.

## Información del problema

Autoría: PR02

Generación: 2026-01-25T21:08:34.010Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
