# Redispersió en taules de dispersió amb direccionament obert fent sondeig lineal

Donada la classe $dicc$ que permet gestionar diccionaris amb claus
enteres, cal implementar els mètodes:

        float factor_de_carrega() const;
        // Pre:  Cert
        // Post: Retorna el factor de càrrega de la taula de dispersió

        void redispersio();
        // Pre:  Cert
        // Post: Redimensiona la taula de dispersió amb una mida el doble que 
        //       l'anterior més un (\_M passa a ser 2*\_M+1)

Els diccionaris s'implementen amb taules de dispersió amb direccionament
obert fent sondeig lineal.

Cal enviar a jutge.org la següent especificació de la classe $dicc$ i la
implementació dels mètodes dins del mateix fitxer (la resta de mètodes
públics ja estan implementats). Indica dins d'un comentari a la
capçalera de cada mètode el seu cost en funció del nombre d'elements del
diccionari $n$.

    #include <iostream>
    using namespace std;
    typedef unsigned int nat;

    class dicc {
      // Taula de dispersió amb direccionament obert fent sondeig lineal.
      public:
        dicc(nat m);
        // Pre: m > 0
        // Post: Crea un diccionari buit en una taula de dispersió de mida m

        ~dicc();
        // Pre:  Cert
        // Post: Destrueix el diccionari

        nat quants() const;
        // Pre:  Cert
        // Post: Retorna quants elements (claus) té el diccionari.

        void print() const;
        // Pre:  Cert
        // Post: Imprimeix per cout del contingut de la taula de dispersió

        void insereix(const int &k);
        // Pre:  Cert
        // Post: Insereix la clau k en el diccionari. Si ja hi era, no fa res.
        //       Redimensiona la taula de dispersió amb una mida el doble que 
        //       l'anterior més un si el factor de càrrega és superior a 0.8

        float factor_de_carrega() const;
        // Pre:  Cert
        // Post: Retorna el factor de càrrega de la taula de dispersió

        void redispersio();
        // Pre:  Cert
        // Post: Redimensiona la taula de dispersió amb una mida el doble que 
        //       l'anterior més un (\_M passa a ser 2*\_M+1)

      private:
        enum Estat {lliure, esborrat, ocupat};
        struct node_hash {
          int   _k;    // Clau
          Estat _est;
        };
        node_hash *_taula;  // Taula amb les claus del diccionari
        nat _M;             // Mida de la taula
        nat _quants;        // Nº d'elements guardats al diccionari

        static long const MULT = 31415926;

        static long h(int k);
        // Pre:  Cert
        // Post: Retorna un valor de dispersió entre 0 i LONG\_MAX a partir de k

        nat busca_node(const int &k) const;
        // Pre:  Cert
        // Post: Retorna la posició on es troba l'element amb la clau k o,
        //       en cas que no trobi la clau, la primera posició no ocupada.

        // Aquí va l'especificació dels mètodes privats addicionals

    };

    // Aquí va la implementació dels mètodes públics factor\_de\_carrega, redispersio i
    // dels mètodes privats addicionals
    };

Degut a que jutge.org només permet l'enviament d'un fitxer amb la
solució del problema, en el mateix fitxer hi ha d'haver l'especificació
de la classe i la implementació dels mètodes $factor\_de\_carrega$ i
$redispersio$ (el que normalment estarien separats en els fitxers $.hpp$
i $.cpp$).

Per testejar la classe disposes d'un programa principal que llegeix un
conjunt d'elements, els insereix en un diccionari i mostra el seu
contingut, desprès llegeix un segon conjunt d'elements, els insereix en
el mateix diccionari i mostra novament el seu contingut.

## Entrada

L'entrada té tres línies: la primera conté un natural positiu amb la
dimensió inicial de la taula de dispersió i les altres dos contenen
enters separats amb espais, són els enters que s'insereixen en el
diccionari.

## Sortida

Escriu el contingut del diccionari dos vegades: desprès d'inserir el
primer conjunt d'enters i desprès d'inserir el segon conjunt d'enters.
Cada vegada es mostra en diferents línies la quantitat d'elements que
té, el factor de càrrega i el contingut de totes les caselles de la
taula de dispersió(la clau si la casella està ocupada, \"LL\" si està
lliure o \"ES\" si està esborrada).

## Observació

Per calcular el valor de dispersió utilitza el mètode $h$ que ja està
implementat i que permet calcular un valor de dispersió entre $0$ i
$LONG\_MAX$ (el valor long int més gran que permet el compilador) a
partir d'una clau entera.

Només cal enviar la classe requerida i la implementació dels mètodes
$factor\_de\_carrega$ i $redispersio$. Pots ampliar la classe amb
mètodes privats. Segueix estrictament la definició de la classe de
l'enunciat.

Indica dins d'un comentari a la capçalera de cada mètode el seu cost en
funció del nombre d'elements del diccionari $n$.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T15:11:41.956Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
