# Misma Estación

Haz un programa que determina si dos fechas pertenecen a la misma
estación del año. Dado que los límites reales de las estaciones varían
en unas horas de año en año, para simplificar consideraremos intervalos
de fechas fijos para todos los años. Los intervalos considerados, con
límites incluidos, son los siguientes:

- Primavera: del 21 de Marzo al 19 de Junio,

- Verano: del 20 de Junio al 21 de Setiembre,

- Otoño: del 22 de Setiembre al 21 de Diciembre,

- Invierno: del 22 de Diciembre al 20 de Marzo del año siguiente.

Para indicar una estación de un año en particular, utilizaremos el
nombre de la estación y el año en que la estación tuvo su fecha inicial.
Algunos ejemplos pueden ser \"`verano de 2020`\", \"`otoño de 1975`\", o
\"`invierno de 1999`\". En este último caso, es importante notar que el
invierno de 1999 tuvo una parte en el año 1999 y otra en el 2000, pero
usamos el año en que empezó para evitar ambigüedades.

## Entrada

La entrada consiste en una secuencia de parejas de números que
representan dos fechas en el formato `AAAAMMDD`, es decir, 4 dígitos
para el año, 2 para el mes, y 2 para el día, en este orden. Además, el
año de las fechas de la entrada no es nunca negativo.

## Salida

La salida consiste en los resultados para cada pareja de fechas de
entrada. Cada línea será el resultado de una pareja de fechas, con un
mensaje diferente según el caso:

- Para fechas en la misma estación, hay que poner \"`Iguales:`\" e
  indicar la estación: \"`Iguales: verano de 1876`\".

- Para fechas en estaciones distintas, hay que poner \"`Diferentes:`\" y
  escribir luego las dos estaciones distintas (en el mismo orden de las
  fechas de entrada correspondientes):
  \"`Diferentes: verano de 2000 y otoño de 2000`\".

## Observaciones

Aunque las fechas se podrían tratar usando `string`s, eso requeriría
acceder a las casillas de un `string` como un vector, así que lo más
conveniente es leerlas como enteros y extraer las partes mediante
operaciones aritméticas.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T15:11:24.296Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
