# Concatenació de piles

Escriviu el codi de l'acció **recursiva** `concatena_piles` que, donades
dues piles d'enters, deixi en una altra pila el resultat de
concatenar-les. Definim la concatenació de dues piles *p* i *q* com
posar la primera sobre la segona mantenint l'ordre dels elements, és a
dir, sense invertir-ne cap de les dues.

``` c++
void concatena_piles(stack<int> &p, stack<int> &q, stack<int> &concatp);
/* Pre: p = P i q = Q i concatp es buida */
/* Post: concatp conte a dalt els elements de P en
   el mateix ordre, i a sota els elements de Q en el mateix
   ordre */
```

Per veure una figura amb les piles corresponents al primer exemple
d'entrada-sortida dels jocs de prova públics, consulteu la versió pdf
d'aquest enunciat.

![image](concat_piles.png){width="10cm"}

## Entrada

L'entrada conté varis blocs separats per línies amb 10 guions
(`----------`). Cada bloc consisteix en dues piles d'enters. Per cada
parell de piles s'introduiran, en aquest ordre, primer el nombre
d'elements de la primera pila i els enters de la primera pila, seguit
del nombre d'elements de la segona pila i els enters de la segona pila.

Per llegir les piles, s'ha utilitzat l'operador `>>` que es troba
definit en el mòdul `stackIOint`.

## Sortida

Com a sortida es mostrarà, per cada parell de piles, les dues piles
d'entrada i la pila resultant de la seva concatenació.

Per escriure les piles, s'ha utilitzat l'operador `<<` que es troba
definit en el mòdul `stackIOint`.

## Observació

Heu d'enviar la solució comprimida en un fitxer .tar:

`tar cvf program.tar pila_concatena.cpp`

Observeu que per compilar us donem el `Makefile`, el mòdul `stackIOint`,
la capçalera del mòdul funcional `pila_concatena.hpp` i el programa
principal `program.cpp`.

Jutge.org també us donarà un semàfor verd si envieu una solució
iterativa, però no serà correcte doncs l'enunciat del problema demana
que la solució enviada sigui **recursiva**.

## Informació del problema

Autoria: Neus Català - Jordi Esteve

Generació: 2026-01-25T21:07:54.863Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
