# Fusió dels elements de dues cues ordenades no circulars

Donada la classe $cua$ que permet encuar elements en una estructura
simplement encadenada en memòria dinàmica, cal implementar el mètode

      void fusiona(const cua<T> &c2);
      // Pre: Les cues del p.i. i c2 estan ordenades de menor a major
      // Post: Al p.i. se li han afegit els elements de c2 ordenadament. c2 no es modifica

que, a partir de dues cues ordenades de menor a major, fusiona els
elements de les dues ordenadament deixant el resultat al paràmetre
implícit, sense modificar la cua $c2$. Pots veure exemples en els jocs
de prova públics.

Cal enviar a jutge.org la següent especificació de la classe $cua$ i la
implementació del mètode dins del mateix fitxer. La resta de mètodes
públics i privats ja estan implementats. Indica dins d'un comentari a la
capçalera del mètode el seu cost en funció del nombre d'elements $n1$ de
la cua del p.i. i nombre d'elements $n2$ de la cua $c2$.

    #include <iostream>
    #include <vector>
    using namespace std;
    typedef unsigned int nat;

    template <typename T>
    class cua { // Cua no circular en memòria dinàmica
      public:
        cua();
        // Construeix una cua buida.

        ~cua();
        // Destrueix el p.i.

        cua(const vector<int> &v);
        // Crea cua amb els elements de v amb el mateix ordre.

        nat longitud() const;
        // Retorna el nombre d'elements del p.i.

        void mostra() const;
        // Mostra el p.i. pel canal estàndard de sortida.

        void fusiona(const cua<T> &c2);
        // Pre: Les cues del p.i. i c2 estan ordenades de menor a major
        // Post: Al p.i. se li han afegit els elements de c2 ordenadament. c2 no es modifica

      private: 
        struct node {
          T info;
          node* seg;
        };
        node* _pri; // Apunta al primer element de la cua
        node* _ult; // Apunta al darrer element de la cua
        nat _mida;

        // Aquí va l'especificació dels mètodes privats addicionals
    };

    // Aquí va la implementació del mètode públic fusiona i privats addicionals

Degut a que jutge.org només permet l'enviament d'un fitxer amb la
solució del problema, en el mateix fitxer hi ha d'haver l'especificació
de la classe i la implementació del mètode $fusiona$ (el que normalment
estarien separats en els fitxers $.hpp$ i $.cpp$).

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $cua$ i un programa principal que llegeix dues
cues, desprès crida el mètode $fusiona$ i finalment mostra el contingut
de les dues cues.

## Entrada

L'entrada conté dues línies formades per seqüències d'enters ordenades,
són els elements que tindran les dues cues inicials.

## Sortida

Es mostra el contingut de les dues cues desprès de fer la fusió. Per
cada cua s'escriu el nombre d'elements de la cua seguit d'un espai i
dels elements de la cua entre claudàtors i separats per espais.

## Observació

Només cal enviar l'especificació de la classe $cua$, la implementació
del mètode $fusiona$ i el seu cost en funció del nombre d'elements $n1$
i $n2$ de les dues cues inicials. Pots ampliar la classe amb mètodes
privats. Segueix estrictament la definició de la classe de l'enunciat.
No es poden usar estructures de dades auxiliars com per exemple vectors.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T15:05:26.923Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
