# Binomial coefficients

The *binomial coefficient* $(N \;\; k)$, $0\leq k\leq N$, is an
important concept in mathematics. Formally, $(N \;\; k)$ represents the
number of ways to choose a subset of $k$ elements from a set of $N$
elements. For example, there are three ways to choose a subset of $2$
elements from a set $\{a,b,c\}$ of three elements, namely $\{a,b\}$,
$\{a,c\}$ and $\{b,c\}$. Hence $(3 \;\; 2) = 3$.

To compute $(N \;\; k)$, it is convenient to use the following recursive
formula: $$(N \;\; k) = (N-1 \;\; k-1) + (N-1 \;\; k).$$ The base case
given by $(N \;\; 0)=(N \;\; N)=1$ for any $N\geq 0$.

The binomial coefficients can be arranged into *Pascal's triangle*:

::: center
  --- --- --- --- ---- ---- ---- ---- ---- --- --- --- ---
                             1                         
                        1         1                    
                   1         2         1               
               1        3         3         1          
           1       4         6         4        1      
       1       5        10        10        5       1  
   1       6       15        20        15       6       1
  --- --- --- --- ---- ---- ---- ---- ---- --- --- --- ---
:::

Each row $N\geq 0$ contains the binomial coefficients
$(N \;\; 0),\ldots,(N \;\; N)$, and each element is the sum of the two
elements immediately above it.

## Input

The input starts with an integer $C$, the number of cases. On each of
the following $C$ lines are two integers $N$ and $k$ satisfying
$0\leq k\leq N\leq 20$.

## Output

For each case, output the binomial coefficient $(N \;\; k)$ on a single
line.

## Problem information

Author: Anders Jonsson

Generation: 2026-01-25T14:59:34.771Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
