# Chess Club

As a tech demo for a chess club, we want a program that reads and
records pairs of names of members of the club who played a chess match,
to know who has played against whom.

The input has two parts: data and queries. First, there is an integer
$n$ indicating how many matches are to be read. Then, there are $n$
lines, each with information of a match. Match information consists of
the names of two players: First the name of the player who played with
white, and second the player who had black pieces.

After the $n$ data lines comes the query part. Here, a line may consists
of a name followed by a question mark, or a question mark followed by a
name. In the former case, the program must print all the names of people
playing black against that name using white. On the latter case, the
program reports the names of people playing white in matches where the
given name played black.

## Input

The input consits of a number $n\ge{0}$, followed by $n$ pairs of names.
After that, there is a blank line, and then a sequence of queries, each
of them consisting of a question mark and a name, or viceversa.

For simplicity, we will assume that:

- Queries always refer to names who played at least a game in the
  queried position.

- There are no repeated matches in the list (i.e. two players can play
  at most twice, swapping colors).

## Output

For each query in the input, the output has the list of names who played
against the player in the query in the appropriate position. The
opponent names must be sorted alphabetically.

Format your output as shown in the examples. Note that there is a blank
line after the response to each query.

## Problem information

Author: ProAl

Generation: 2026-01-25T14:52:55.454Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
