# Camí més llarg en un arbre

Implementeu una funció **RECURSIVA** que, donat un arbre binari
d'enters, retorna la llista de valors que es troben des de l'arrel
seguint el camí més llarg de l'arbre. En cas que hi hagi varis camins
màxims, s'haurà d'escollir el camí que va el més a l'esquerra possible.
Aquesta és la capcelera:

    // Pre:
    // Post: Retorna la llista d'elements que es troben a t, baixant des de l'arrel i
    //       seguint el camí més llarg. En cas de varis camins màxims,
    //       escull el de més a l'esquerra.
    list<int> longestLeftmostPath(BinaryTree<int> t);

Aquí tenim un exemple de paràmetre d'entrada de la funció i la
corresponent sortida:

    longestLeftmostPath(3(1(,5),3(2(1,7),))) => [3,3,2,1]

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`Makefile, program.cpp, BinaryTree.hpp, longestLeftmostPath.hpp`. Us
falta crear el fitxer `longestLeftmostPath.cpp` amb els corresponents
`includes` i implementar-hi la funció anterior. Quan pugeu la vostra
solució al jutge, només cal que pugeu un tar construït així:


    tar cf solution.tar longestLeftmostPath.cpp

## Entrada

L'entrada té un nombre arbitrari de casos. Cada cas consisteix en una
línia amb un string describint un arbre binari d'enters. Fixeu-vos en
que el programa que us oferim ja s'encarrega de llegir aquestes
entrades. Només cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent camí més llarg i més a
l'esquerra de l'arbre. Fixeu-vos en que el programa que us oferim ja
s'encarrega d'escriure aquesta sortida. Només cal que implementeu la
funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema. En les
crides recursives, incloeu la hipòtesi d'inducció, és a dir una
explicació del que es cumpleix després de la crida, i també la funció de
fita/decreixement o una justificació de perquè la funció recursiva
acaba.

Molt possiblement, una solució directa serà lenta, i necessitareu crear
alguna funció recursiva auxiliar per a produïr una solució més eficient
capaç de superar tots els jocs de proves. En particular, sembla
convenient precalcular abans l'arbre d'alçades corresponent a l'arbre
d'entrada, tot i que també pot passar que el compilador optimitzi bé una
solució aparentment més lenta.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T21:07:06.524Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
