# Maximum of a Section

Given a sequence of integers, we specify a "section" of it using two
integers \@a@ and \@b@. This is exactly as in the related problem
Identifying Sections: the section is the part of the sequence that
starts immediately after the first occurrence of \@a@, if any, and ends
immediately before the first occurrence of \@b@ after the first
occurrence of \@a@, if any.

For instance, given the sequence 6, 5, 1, 2, 1, 4, 3, 5, 4, 3, 5, 1 with
\@a = 1@ and \@b = 5@ we specify the subsequence 2, 1, 4, 3 that starts
just after the first 1 and ends just before the first 5 after that 1.

Write a program that finds the maximum value of a specified section. In
the case above, it would be 4. The input indicates first \@a@ and \@b@,
in one line, separated with whitespace; the subsequent line (or lines)
constitute the sequence.

In the related problem Identifying Sections, we knew the length of the
sequence beforehand, and we had several cases. Those two aspects change
here, as does the handling of empty sections: if \@a@ does not appear in
the sequence, of if it appears but \@b@ does not appear subsequently,
your program must print \"nonexistent section\"; if they appear but
there are no intervening numbers, your program must print \"empty
section\"; otherwise, your program must print \"maximum is: \" followed
by the corresponding maximum value.

## Problem information

Author: José Luis Balcázar

Generation: 2026-01-25T14:52:25.423Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
