# Generar un arbre a partir dels seus recorregurs en inordre i postordre

**Preliminars**

Recordeu que el recorregut en **inordre** d'un arbre és la llista dels
nodes de l'arbre ordenada com segueix: en primer lloc, el recorregut en
inordre del fill esquerra de l'arbre, després l'arrel de l'arbre, i
després el recorregut en inordre del fill dret de l'arbre. En altres
paraules: $$\begin{align*}
inordre(x(t_1,t_2)) &= inordre(t_1)\;\cdot{}\;x\;\cdot{}\;inordre(t_2) \\
inordre(()) &= ()
\end{align*}$$ és a dir, l'$inordre$ de l'arbre buit és l'arbre buit.

Recordeu també que el recorregut en **postordre** d'un arbre és la
llista dels nodes de l'arbre ordenada com segueix: en primer lloc, el
recorregut en postordre del fill esquerra de l'arbre, després el
recorregut en postordre del fill dret de l'arbre, i finalment l'arrel de
l'arbre. En altres paraules: $$\begin{align*}
postordre(x(t_1,t_2)) &= postordre(t_1)\cdot{}postordre(t_2)\cdot{}x \\
postordre(()) &= ()
\end{align*}$$ és a dir, el postordre de l'arbre buit és l'arbre buit.

Per exemple, considereu el següent arbre, que té 12 nodes amb valors
$1,2,\ldots,12$:

                      9
                      |
                  ---- ----
                 |         |
                 2         6
                 |
          ------- -------
         |               |
         12              10
         |               |
     ---- ----       ---- ----
    |         |     |         |
    3         7     4         11
              |               |
          ---- ----       ----
         |         |     |
         1         8     5

El seu recorregut en inordre és: 3, 12, 1, 7, 8, 2, 4, 10, 5, 11, 9, 6.\
El seu recorregut en postordre és: 3, 1, 8, 7, 12, 4, 5, 11, 10, 2, 6,
9.

Ara bé, seria possible, si només coneguéssim els recorreguts en inordre
i postordre, reconstruir l'arbre original?

**Exercici:**

Heu d'implementar un programa que llegeix varis casos d'entrada. Cada
cas comença amb la mida $n$ d'un arbre binari d'enters desconegut, i ve
seguit dels recorreguts en inordre i postordre d'aquest arbre
desconegut, a on cadascun d'aquests recorreguts consisteix en una llista
amb tots els valors possibles entre $1$ i $n$. Amb aquesta informació,
haureu de construir l'arbre i escriure'l per la sortida.

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix el fitxer
`BinTree.hh`, que haureu d'utilitzar per a compilar. Només cal que creeu
`main.cc`, posant-hi els includes que calguin i implementant el programa
i les funcions que calguin per tal de solucionar l'exercici. Només cal
que pugeu `main.cc` al jutge.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres de sortida, o bé INLINEFORMAT o bé VISUALFORMAT. Després ve
una línia en blanc. Després venen un nombre arbitrari de casos. Cada cas
consisteix en una primera línia amb un nombre $n$, una segona línia amb
els nodes $1$ i $n$ en inordre i separats per espais en blanc, i una
tercera línia amb els nodes $1$ i $n$ en postordre i separats per espais
en blanc. Després de cada cas hi ha una línia en blanc.

## Sortida

Per a cada cas, cal escriure l'arbre binari amb $n$ nodes que contenen
tots els valors entre $1$ i $n$, i tal que el seu recorregut en inordre
és la primera llista de valors, i el seu recorregut en postordre és la
segona llista de valors.

## Observació

**AVÍS:** Aquest problema requereix una anàlisi a fons abans començar a
programar, perquè cal pensar detingudament l'estratègia i sobretot els
detalls. La solució no és llarga però no hi arribareu per \"assaig i
error\", és imperatiu fer servir paper i llapis primer. Els conceptes
que cal tenir molt presents mentalment per poder arribar a la solució
són:

- la definició recursiva de l'inordre i el postordre, i la posició de
  l'arrel en els dos casos,

- com fer una *immersió*, és a dir, utilitzar paràmetres a les crides
  recursives per establir el context en el qual s'executa cada crida.

En particular, cal notar que si tant inordre `I` com postordre `P`
s'emmagatzemen en vectors, els inordres i postordres dels subarbres són
subseqüències dels vectors `I` i `P`, amb posicions inicials i finals
que són indexs a `I` i `P`.

La vostra solució ha de treballar amb `BinTree`, tot i que podeu
utilitzar altres estructures de dades presentades al curs com a element
de suport.

Per a tractar l'entrada i la sortida, podeu utilitzar aquest esquema:

    #include <iostream>
    using namespace std;
    #include "BinTree.hh"
    /* Pots afegir més includes */

    typedef BinTree<int> BT;

    /* Les funciones que vulguis */

    int main() {
        string format;
        cin >> format;
        int n;
        while (cin >> n) {
            /* Llegir dues seqüències de n enters cadascuna. */

            BinTree t;
            /* Calcular t a partir de les dues seqüències. */

            t.setOutputFormat(format=="INLINEFORMAT"?  BT::INLINEFORMAT : BT::VISUALFORMAT);
            cout << t << endl;
      	}
    }

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost lineal i capaç
de superar els jocs de proves públics i privats. Entenem com a solució
lenta una que no és ràpida, però és correcta i capaç de superar els jocs
de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T14:49:29.216Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
