# Mètode de la classe cua que divideix una cua en dues cues

Implementa un nou mètode de la classe `Queue` que divideix els elements
de la cua entre el paràmetre implícit i la cua que passen com a
paràmetre. Els elements en posició senar estaran en el paràmetre
implícit i els elements en posició parell en la cua que ens passen com a
paràmetre.

D'entre els fitxers que s'adjunten en aquest exercici, trobaràs
`queue.old.hpp`, a on hi ha una implementació de la classe genèrica
`Queue`. En primer lloc, hauràs de fer:

    cp queue.old.hpp queue.hpp

A continuació si obres el fitxer `queue.hpp` al final del mateix
trobaràs el mètode que has d'implementar:

    // Pre: Sigui [e1,e2...,en] el contingut inicial de la cua des del 
    // principi fins al final i q és buida.
    // Post: El contingut final del pi és [e1, e3, e5, ...] (manté els 
    // elements en posicions senars) i el contingut de q és [e2, e4, ...] 
    // (conté els elements en posicions parells).
    void split(Queue &q);

**[IMPORTANT]{style="color: red"}**: No toquis la resta de la
implementació de la classe, excepte si per algun motiu, consideres que
necessites afegir algun mètode auxiliar o atribut a la part privada.

D'entre els fitxers que s'adjunten a l'exercici també hi ha
`program.cpp` (programa principal) i `Makefile` per a compilar i generar
l'executable. El programa principal que t'oferim ja s'encarrega de
llegir les cues i fer les crides al mètode indicat. **Només cal que
implementis el mètode `split`**.

Per a pujar la teva solució, has de crear el fitxer `solution.tar` així:

    tar cf solution.tar queue.hpp

## [Observació 1]{style="color: blue"}

Hauries d'aconseguir implementar el mètode demanat a base d'intercanviar
els punters de l'objecte. De fet, una solució a base d'usar `push` i
`pop` potser et permetrà passar els jocs de proves, però atès que la
solució ha de ser eficient en temps i espai, aquest tipus de solució
serà fortament penalitzat.

## [Observació 2]{style="color: blue"}

Recorda que si crees funcions auxiliars, has d'afegir-hi les
corresponents **Precondició** (Pre) i **Postcondició** (Post). En els
bucles inclou l'**invariant del bucle** (Inv) i la **funció de fita**
(FF). En les funcions recursives inclou la **hipòtesi d'inducció** (HI)
i la **funció de fita** (FF).

## Entrada

L'entrada del programa és una seqüència de cues. Per llegir les cues,
s'utilitza l'operador `>>` que es troba definit en el fitxer
`queue.hpp`.

## Sortida

Per cada cua s'escriurà el resultat del mètode `split`, és a dir, les
dues cues (paràmetre implícit i paràmetre). Per escriure les cues, s'ha
utilitzat l'operador `<<` que es troba definit en el fitxer `queue.hpp`.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T21:05:56.250Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
