# Control PRO2 - Torn 1 (tardor 2015)

Hem decidit estendre la classe `Cjt_estudiants` que heu vist al
laboratori amb una nova funcionalitat: obtenir el nombre d'estudiants
dins un interval de notes.

Les notes dels estudiants es classifiquen en 10 intèrvals, identificats
amb nombres del 0 al 9. L'intèrval 0 comprèn les notes més grans o
iguals que 0 y menors que 1, l'intèrval 1 cobreix les notes més grans o
iguals que 1 y menors que 2 i així successivament. Suposarem que la nota
màxima (10) pertany a l'intèrval 9. La nota dels alumnes no presentats
no pertany a cap intèrval.

Hem optat per afegir una nova operació pública amb la següent
especificació:

    int nombre_est_interval(int i) const;
    /* Pre: 0 <= i <= 9 */
    /* Post: el resultat és el nombre d'estudiants del paràmetre implícit amb nota a l'interval i */

Això ha suposat afegir un atribut nou a la classe. Tenint això en
compte, només heu d'implementar eficientment les següents operacions:

    void afegir_estudiant(const Estudiant &est, bool& b);
    /* Pre: el paràmetre implícit no està ple */
    /* Post: b = indica si el p.i. original conté un estudiant amb el dni d'est;
       si b = fals, s'ha afegit l'estudiant est al paràmetre implícit */

    void esborrar_estudiant(int dni, bool& b);
    /* Pre: cert */
    /* Post: b indica si el paràmetre implícit original tenia un estudiant 
       amb el dni dni; si b, aquest estudiant ha quedat eliminat
       del paràmetre implícit */

## Observació

Heu de lliurar un fitxer `solucio.cc` amb una implementació eficient de
les operacions `afegir_estudiant` i `esborrar_estudiant` que ha de tenir
el següent format:

    #include "Cjt_estudiants.hh"

    void Cjt_estudiants::afegir_estudiant(const Estudiant &est, bool& b)
    {
      ... // codi de la implementació
    }

    void Cjt_estudiants::esborrar_estudiant(int dni, bool& b)
    {
      ... // codi de la implementació
    }

Copieu aquesta plantilla en el vostre `solucio.cc` i completeu-la. El
vostre `solucio.cc` no pot contenir la implementació d'altres operacions
de la classe.

A l'apartat *Public files* del Jutge us proveïm amb material addicional
comprimit en un fitxer .tar. Podeu descomprimir aquest fitxer amb la
comanda

       tar -xvf nom_fitxer.tar

Aquest material addicional consisteix en els següents fitxers:

- `Cjt_estudiants.hh`: l'especificació Pre/Post de totes les operacions
  públiques i privades d'aquesta nova versió de la classe
  `Cjt_estudiants`, així como la definició dels camps privats. Fixeu-vos
  que hi ha un atribut nou: un vector `intervals`, que conté el nombre
  d'estudiantes de cada intèrval. Aquest atribut ens ha permès
  implementar amb la màxima eficiència l'operació `nombre_est_interval`
  i cal actualitzar-lo en les operacions modificadores de la classe.
  **És molt important que la implementació de les operacions que us hem
  encarregat tingui en compte i preservi l'invariant de la representació
  de la classe `Cjt_estudiants`**. Fixeu-vos també que hem afegit dues
  operaciones privades, `incrementar_interval` i `decrementar_interval`
  que us recomanem que useu per implementar `afegir_estudiant` i
  `esborrar_estudiant`.

- `Cjt_estudiants.cc`: la implementació de totes de les operacions de la
  nova versió de la classe `Cjt_estudiants` tret de les operacions
  `afegir_estudiant` i `esborrar_estudiant`.

- `Estudiant.hh`: l'especificació de la classe `Estudiant` i la
  definició dels seus atributs. No presenta cap novetat, tret d'una
  operació addicional, `comp`, que permet comparar dos estudiants.

- `Estudiant.cc`: la implementació dels mètodes de la classe
  `Estudiant`.

- `pro2.cc`: un programa principal que podeu fer servir per provar les
  operacions públiques d'aquesta versió de la classe `Cjt_estudiants`.

- `llegeixme.txt`: instruccions per a generar l'executable del programa
  `pro2` i provar-lo.

Valorarem positivament que la solució no contingui instruccions
(especialment bucles o crides a operacions costoses) ni objectes
(especialment vectors o conjunts) innecessaris. No es pot emprar cap
estructura de dades que no hagi aparegut a les sessions 1-4 de
laboratori.\
 \
Quan feu els enviaments el Jutge us indicarà quants jocs de proves
passeu i de quin tipus (public o privat). El joc de proves anomenat
`public` s'explica al fitxer `llegeixme.txt`. El `privat1` és molt
semblant al `public`. Els `privat2` i `privat3` proven situacions
especials.

## Informació del problema

Autoria: Professors de PRO2

Generació: 2026-01-25T14:41:50.809Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
