# Shift left or right

Design a circuit that shifts an $N$-bus one position to the left or to
the right. The direction of the shift is determined by a control signal
called `LR`. When `LR`=0, the shift must be to the left. When `LR`=1,
the shift must be to the right. $N$ must be a parameter of the circuit
with default value 8.

## Specification

``` verilog
module shift_left_right(in, LR, out);
    parameter N=8;
    input [N-1:0] in;
    input LR;
    output [N-1:0] out;
```

## Input

- `in` is the $N$-bit input bus.

- `LR` is the control signal that determines the direction of the shift.

## Output

- `out` is the value of the bus shifted one position to the left or
  right.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:18:58.011Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
