# Suma d'una pila

**Preliminars**

En aquest exercici extendrem la classe `Stack` suposant que el tipus `T`
dels elements de la pila té definida la operació de suma `+`, és a dir,
que dues variables de tipus `T` es poden sumar. Aquesta suma satisfarà
la propietat d'associativitat usual ($x+(y+z)=(x+y)+z$), i tindrà
element neutre (per exemple, $0$ és el neutre per a la suma d'enters, i
l'string buit és el neutre per a la suma d'strings).

També suposem que una variable `x` de tipus `T` permet una assignació
`x = 0`, de manera que, internament, a `x` se li assigna el neutre de la
suma.

Testejarem l'exercici amb el tipus `int` i amb un tipus contenidor
d'`string` que permetrà fer assignacions `x = 0` (internament
s'assignarà l'string buit). Fixeu-vos que en el cas d'`strings` la suma
és de fet la concatenació d'`strings`, i que no és commutativa. Per
exemple, \"a\"+\"b\" = \"ab\" $\neq$ \"ba\" = \"b\"+\"a\".

Els jocs de proves grans d'aquest exercici es fan amb `int` i no pas amb
`string` per tal d'evitar el cost adicional de concatenar strings grans.

**Exercici**

Implementeu un nou mètode de la classe Stack que retorni la suma dels
elements continguts a la pila des del fons fins al top. És a dir, si
$[a_1,\ldots,a_n]$ és el contingut de la pila des del fons fins al top,
el mètode ha de retornar $a_1+\cdots+a_n$.

D'entre els fitxers que s'adjunten en aquest exercici, trobareu
`stack.hh`, a on hi ha una implementació de la classe genèrica `Stack`.
Haureu de buscar dins `stack.hh` les següents línies:

    // Pre:  Sigui [a1,...,an] el contingut actual de la pila des del fons fins al top.
    // Post: Retorna a1+...+an.
    // Descomenteu les següents dues linies i implementeu el mètode:
    // T sum() {
    // }

Descomenteu les dues linies que s'indiquen i implementeu el mètode.
Potser necessitareu modificar més coses de la classe depenent de quin
enfoc seguiu. Aquí us en recomanem dos:

- **Enfoc senzill i ineficient:** una implementació senzilla del mètode
  `sum`, inicialitzant una variable de tipus T a $0$ (que es
  transformarà automàticament en el neutre de la suma), i recorrent i
  sumant-hi els elements de la pila, hauria de ser suficient per a
  superar els jocs de proves públics, però no els privats.

- **Enfoc eficient:** la idea és afegir un nou camp de tipus T a
  l'`struct Item` que guardi, per a cada item, la suma de tot el que hi
  ha per sota a la pila més el `value` d'aquest mateix `Item`. Per
  exemple, podem anomenar `sumbelow` a aquest nou camp. Cada cop que fem
  un push, haurem d'inicialitzar el camp `sumbelow` del nou `Item` com
  la suma del `sumbelow` del que era fins ara el top de la pila més el
  `value` que rebem com a paràmetre.

D'entre els fitxers que s'adjunten a l'exercici també hi ha `main.cc`
(programa principal), i el podeu compilar directament, doncs inclou
`stack.hh`. Només cal que pugeu `stack.hh` al jutge.

## Entrada

L'entrada del programa té una primera línia amb o bé **`int`** o bé
**`string`**, que indica el tipus T dels elements de la pila `s` amb la
que treballarà el programa, que se suposa inicialment buida. Després, hi
ha una seqüència d'instruccions del següent tipus que s'aniran aplicant
sobre la pila:

    push x (x és de tipus T)
    pop
    top
    print
    sum

Se suposa que la seqüència d'entrada serà correcta (sense pop ni top
sobre pila buida).

El programa principal que us oferim ja s'encarrega de llegir aquestes
entrades i fer les crides als corresponents mètodes de la classe pila.
Només cal que implementeu el mètode abans esmentat.

## Sortida

Per a cada instrucció `top`, s'escriurà el top actual de la pila, per a
cada instrucció `print`, s'escriurà el contingut de la pila, i per a
cada instrucció `sum`, s'escriurà la suma dels elements de la pila des
del fons fins al top. El programa que us oferim ja fa això. Només cal
que implementeu el mètode abans esmentat.

## Observació

Avaluació sobre 10 punts: (Afegiu comentaris si el vostre codi no és
prou clar)

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, on totes les
operacions tenen cost constant (excepte `PRINT`, i suposant que operar
amb elements de tipus T té cost constant), i capaç de superar els jocs
de proves públics i privats. Entenem com a solució lenta una que no és
ràpida, però és correcta i capaç de superar els jocs de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-27T18:52:07.895Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
