# Suma màxima dels camins d'un arbre general

Considerem la representació habitual amb nodes de la classe *ArbreGen*
per manegar arbres generals genèrics d'elements de tipus T.

Un arbre només té un atribut: un punter al primer node. Cada node conté
la seva info i un vector de punters, que representa els seus succesors.
Per a tot node intern, el vector no és buit; per a tota fulla, el vector
és buit.

Recordeu que hem definit un *camí* a un arbre com una successió de nodes
que van de l'arrel a una fulla. Us demanem implementar una operació nova
d'aquesta classe, amb la següent especificació pre/post, on el tipus $T$
ha de tenir definides les operacions $+$ (suma) i $>$ (més gran que):

    T max_suma_cami() const 
    /* Pre: el parametre implicit no es buit */
    /* Post: el resultat es la suma del cami de suma maxima del parametre implicit */

Exemple: si $a$ és el següent arbre general d'enters

<figure data-latex-placement="h!">
<embed src="arbreG.eps" />
</figure>

llavors la crida **a.max_suma_cami()** ha de retornar 29 $(7+9+13)$. Si
en comptes dels valors 12 i 13 tinguéssim 1 i -2, el resultat hauria de
ser 19 $(7+2+10$ o també $7+4+8)$.

Dissenyeu aquesta operació sense utilitzar cap de les operacions
primitives del arbres, accedint directament als atributs de la classe
*ArbreGen*.

## Entrada

L'entrada és un arbre general en el paràmetre implícit.

## Sortida

La sortida és el resultat de la suma del camí de suma màxima del
paràmetre implícit.

## Observació

Només s'ha d'enviar un fitxer que contengui la funció amb la capçalera
de l'enunciat i qualsevol altra funció auxiliar que cregueu convenient,
sense la funció main i sense posar-hi cap "include".

## Informació del problema

Autoria: Alberto Moreno (adaptador), Ramon Ferrer i Cancho (responsable)

Generació: 2026-01-27T18:51:56.914Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
