# Creació d'una cua circular a partir d'un vector

Donada la classe $cua$ que permet guardar seqüències d'enters amb una
cua simplement encadenada, sense fantasma i circular, cal implementar el
mètode constructor

    cua(const vector<int> &v)

que crea una cua amb els elements del vector $v$ amb el mateix ordre.

Cal enviar a jutge.org només la implementació del mètode constructor. La
classe $cua$ té la següent especificació:

    #include <vector>
    using namespace std;
    typedef unsigned int nat;

    class cua {
      // cua simplement encadenada, sense fantasma i circular.
      private:
        struct node {
          int info;  // Informació del node
          node *seg; // Punter al següent element
        };
        node *_ult; // Punter a l'últim element
        nat _long;  // Nombre d'elements

        node* copiar(node* n, node* fi, node* ini);

      public:
        cua();
        // Pre: True
        // Post: El p.i. és una cua buida.

        cua(const vector<int> &v);
        // Pre: True
        // Post: El p.i. conté els elements de v amb el mateix ordre.

        // Tres grans: constructora per còpia, operador d'assignació i destructora.
        cua(const cua &c);
        cua& operator=(const cua &c);
        ~cua();

        void desencuar();
        // Pre: True
        // Post: Treu el primer element de la cua. Llança un error si la cua és buida.

        const int& primer() const;
        // Pre: True
        // Post: Obté el primer element de la cua. Llança un error si la cua és buida.

        bool es_buida() const;
        // Pre: True
        // Post: Consulta si la cua és buida o no.

        nat longitud() const;
        // Pre: True
        // Post: Retorna el nombre d'elements del p.i.

        static const int CuaBuida = 310;
    };

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $cua$ i un programa principal que processa línies
d'enters amb els que crear vectors i posteriorment cues.

## Entrada

L'entrada conté vàries línies formades per seqüències d'enters.
Cadascuna d'elles són els elements que tindrà el vector amb el que es
construirà cada cua.

## Sortida

Per a cada línia d'entrada, escriu una línia amb el resultat: El nombre
d'elements de la cua seguit d'un espai i dels elements de la cua entre
claudàtors i separats per espais.

## Observació

Cal enviar la solució (el fitxer $solution.cpp$) comprimida en un fitxer
$.tar$:

    tar cvf solution.tar solution.cpp

Només cal enviar la implementació del mètode constructor a partir de
vector. Segueix estrictament la definició de la classe de l'enunciat.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T21:05:04.565Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
