# Esborra fitxers amb una extensió

En aquest exercici, considerarem arbres binaris d'strings que
representen arbres de directoris i fitxers. Observeu el següent exemple:

                                      fotos
                                        |
                          -------------- --------------
                         |                             |
                      antigues                       noves
                         |                             |
              ----------- -----------            ------ ------
             |                       |          |             |
          familia                  amics     familia        amics
             |                       |          |             |
        ----- -----              ----       ---- ----          ----
       |           |            |          |         |             |
    pau.jpg    nuria.png    joel.jpeg     casa    vacances     marta.png
                                                     |
                                               ------ ------
                                              |             |
                                           roma.bmp    newyork.png

En un arbre de directoris i fitxers hi ha dos tipus de nodes: directoris
i fitxers. L'string d'un directori és no buit i està format per lletres
minúscules. L'string d'un fitxer està format per una primera seqüència
no buida de lletres minúscules, seguida del caràcter '.', seguit d'una
segona seqüència no buida de lletres minúscules. Aquesta segona
seqüència s'anomena la extensió del fitxer. Els fitxers han de ser
necessàriament fulles de l'arbre. Els directoris poden ser nodes interns
i també fulles.

Volem executar una comanda per a esborrar tots els fitxers que pengen
del directori principal i que tenen una certa extensió. Per exemple, si
volguessim esborrar tots els fitxers amb extensió `png` (La típica
comanda `rm -r *.png`), l'arbre quedaria transformat així:

                           fotos
                             |
                   ---------- ----------
                  |                     |
               antigues               noves
                  |                     |
             ----- -----            ---- ----
            |           |          |         |
         familia      amics     familia    amics
            |           |          |
        ----        ----       ---- ----
       |           |          |         |
    pau.jpg    joel.jpeg     casa    vacances
                                        |
                                    ----
                                   |
                                roma.bmp

Heu d'implementar una funció `RECURSIVA` que rep un arbre de directoris
i fitxers, i també rep un string que representa una extensió, i retorna
un nou arbre de directoris i fitxers que és el resultat d'esborrar tots
els fitxers amb aquella extensió de l'arbre rebut. Aquesta és la
capcelera:

    // Pre:  Els nodes de 't' o bé son strings no buits de lletres minuscules, o bé
    //       son de la forma "s.e", on s i e son strings no buits de lletres minúscules.
    //       En l'últim cas, el node ha de ser una fulla, i e s'anomena la extensió de la fulla.
    // Post: Retorna l'arbre resultant d'esborrar de t tots els nodes amb strings de
    //       la forma "s.e" a on 'e' és igual a 'extension'.
    BinTree<string> removeAll(const string &extension, const BinTree<string> &t);

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`main.cc, BinaryTree.hh, removeAll.hh`. Us falta crear el fitxer
`removeAll.cc` amb els corresponents `includes` i implementar-hi la
funció anterior. Només cal que pugeu `removeAll.cc` al jutge.

**Observació:** Donat un string `s` i un índex `i`, podeu utilitzar
`s.substr(i)` per a obtenir el substring que és el sufix de `s` a partir
de posició `i`.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas té una primera linia amb la extensió, un
string no buit de lletre minúscules, i després una descripció d'un arbre
binari que representa una expressió. Fixeu-vos en que el programa que us
oferim ja s'encarrega de llegir aquesta entrada. Només cal que
implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent arbre resultant.
Fixeu-vos en que el programa que us oferim ja s'encarrega d'escriure
aquesta sortida. Només cal que implementeu la funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema. Avaluació
sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T14:31:01.109Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
