# City Center

The city center of the capital of Meashara contains two kinds of
streets: horizontal and vertical ones. Vertical ones go roughly from
South to North; there are sometimes deviations, but the angle between
the street and Sorth-Nouth is never greater than 30 degrees. Likewise,
horizontal ones go roughly from West to East, and the deviation is never
greater than 30 degrees. Both vertical and horizontal streets are
numbered with consecutive integers.

Even though some street fragments don't go strictly North or East, the
structure of the city center has some regularity: the region between two
neighboring vertical streets, and two neighboring horizontal streets, is
always a parallelogram.

![image](kyc){width="8cm"}

George Zynoulus is running a company producing navigational systems.
Currently the navigational system is able to tell the receiver's
coordinates. However, this is not enough for the citizens, who rather
want to know their current address. Your task is to, given a description
of streets and coordinates, quickly determine the address of the
crossing that the receiver is currently on, that is, the numbers of
horizontal and vertical streets which cross there.

## Input

The first row contains three numbers $1\leq n\leq25000$,
$1\leq e\leq25000$ and $1\leq k\leq25000$. These are, respectively,
number assigned to the last horizontal street, number assigned to the
last vertical street, and the number of queries (coordinates of
crossings recorded by the receiver).

We assume that the 0th Vertical Street and the 0th Horizontal Street
cross at (0,0). Point (1,0) is 1 Measharan meter to the East, and point
(0,1) is 1 Measharan meter to the North.

For $i=1..n$, each following line contains two integers $x^N_i$ and
$y^N_i$, which denote the coordinates of the crossing of $i$-th
Horizontal Street and $0$th Vertical Street. Each $y^N_i$ is greater
than the previous one.

Then, for $i=1..e$, each following line contains two integers $x^E_i$
and $y^E_i$, which denote the coordinates of the crossing of 0th
Horizontal Street and $i$-th Vertical Street. Each $x^N_i$ is greater
than the previous one.

Then, for $i=1..k$, each following line contains two numbers $x_i$ and
$y_i$. These are coordinates of the crossing that we have to find.

Each point in the city center has coordinates $(x,y)$ such that
$-2000000000\leq x,y\leq 2000000000$.

## Output

Output should consist of $k$ rows. In $i$-th row of input give the
address of $i$-th crossing.

## Problem information

Author: Eryk Kopczynski

Generation: 2026-01-25T14:30:26.396Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
