# Cotxes i distancies

Ens donen una llista de cotxes d'entrada. Per a cada cotxe ens donen el
seu nom (un string), la màxima distància que poden recorrer amb el
dipòsit ple (un natural) i el seu preu (un natural). Aquesta llista ens
la donen ordenada de menys a més distància. Per exemple, ens poden donar
la llista:

    Corbette53 218 210513
    Peugot307 415 33313
    Ibiza2016 571 28216
    Coupe2008 613 56198
    Portofino 761 83690

Fixeu-vos que `Portofino` apareix en últim lloc perquè la seva distància
(761) és la màxima.

També ens donen una parella de valors enters $[p_1,p_2]$, que representa
un interval de distàncies. Hem de considerar els cotxes que tenen una
distància dins de l'interval $[p_1,p_2]$, calcular la suma dels seus
preus, i escriure els noms d'aquests cotxes (en ordre invers al de la
llista).

Seguint amb l'exemple, suposeu que ens donen l'interval $[312,721]$.
Fixeu-vos que els cotxes `Peugot307, Ibiza2016 i Coupe2008` són els que
apareixen a la llista (en aquest ordre) amb una distància major o igual
a $312$ i menor o igual a $721$. Llavors hauriem d'escriure la suma dels
seus preus i els seus noms (en ordre invers):

    117727 Coupe2008 Ibiza2016 Peugot307

Per a resoldre aquest exercici, és obligatori usar la següent declaració
i implementar i usar convenientment les següents funcions:

    struct Cotxe {
        string nom;
        int distancia;
        int preu;
    };

    typedef vector<Cotxe> Cotxes;

    // Llegeix el nom, la distància i el preu d'un cotxe de l'entrada estandar,
    // crea el cotxe amb aquestes dades i el retorna.
    Cotxe llegirCotxe();

    // Retorna cert sii el cotxe que és rep com a paràmetre té una distància
    // dins de l'interval [p1,p2].
    bool pertanyAInterval(const Cotxe &cotxe, int p1, int p2);

## Entrada

La primera línia de l'entrada té un natural $n$, el nombre de cotxes.
Després venen $n$ línies, on cadascuna descriu un cotxe, amb el nom (un
string de lletres majúscules i minúscules i dígits), la distància que
pot recorrer (un natural) i el preu (un natural). Després tenim una nova
línia amb un natural positiu $m$, el nombre de casos d'intervals.
Després tenim $m$ línies, on cadascuna té dos naturals $p_1,p_2$, que
cumpleixen $p_1\leq{}p_2$ i descriuen un interval de distàncies
$[p_1,p_2]$.

## Sortida

Per a cadascun dels $m$ casos $[p_1,p_2]$, s'ha d'escriure una línia.
Aquesta línia conté, en primer lloc, la suma dels preus dels cotxes que
tenen una distància dins de l'interval $[p_1,p_2]$. Després, la línia
conté els noms d'aquests mateixos cotxes en ordre invers del de la
llista.

## Observació

De cara a superar els jocs de proves públics i obtenir una bona nota (8
sobre 10 com a molt) n'hi ha prou amb que feu una implementació senzilla
basada en cerques i recorreguts bàsics. Ara bé, els jocs de proves
privats són grans ($n$ i $m$ són grans, tot i que el nombre de cotxes
dins de cada interval demanat és petit en aquests jocs de proves
privats). Per tant, si voleu aspirar a superar tots els jocs de proves
privats i obtenir la màxima nota haureu d'implementar un esquema de
cerca més eficient.

## Informació del problema

Autoria: FOPR

Generació: 2026-01-25T14:27:28.063Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
