# Control PRO2 - Torn 1 - Problema 1 (primavera 2019)

Hem decidit estendre la classe `Cjt_estudiants` que heu vist al
laboratori amb dues noves funcionalitats: obtenir el nombre d'estudiants
presentats (és a dir, que tenen nota) i obtenir el nombre d'estudiants
aprovats (és a dir, amb nota més gran o igual que la meitat de la nota
màxima possible).

Hem optat per afegir dues noves operacions públiques amb la següent
especificació:

      int presentats() const;
      /* Pre: cert */
      /* Post: el resultat és el nombre d'estudiants del paràmetre implícit amb
         nota */
      
      int aprovats() const;
      /* Pre: cert */
      /* Post: el resultat és el nombre d'estudiants del paràmetre implícit amb
         nota >= Estudiant::nota_maxima()/2 */

Això ha suposat afegir dos atributs nous a la classe. Tenint això en
compte, només heu d'implementar eficientment les següents operacions:

    void afegir_estudiant(const Estudiant &est, bool& b);
    /* Pre: el paràmetre implícit no està ple */
    /* Post: b = indica si el p.i. original conté un estudiant amb el dni d'est;
       si b = fals, s'ha afegit l'estudiant est al paràmetre implícit */

    void esborrar_estudiant(int dni, bool& b);
    /* Pre: cert */
    /* Post: b indica si el paràmetre implícit original tenia un estudiant 
       amb el dni dni; si b, aquest estudiant ha quedat eliminat
       del paràmetre implícit */

## Observació

Heu de lliurar un fitxer `solution.cc` amb una implementació eficient de
les operacions `afegir_estudiant` i `esborrar_es­tu­diant`. Aquest fitxer
no pot contenir la implementació d'altres operacions de la classe.

A l'apartat *Public files* del Jutge (icona del gatet) us proveïm amb
una plantilla pel fitxer `solution.cc` que només cal completar. A més,
trobareu material addicional, tot comprimit en un fitxer .tar. Podeu
descomprimir aquest fitxer amb la comanda

       tar -xvf nom_fitxer.tar

Aquest material addicional consisteix en els següents fitxers:

- `Cjt_estudiants.hh`: les capçaleres i l'especificació Pre/Post de
  totes les operacions públiques i privades d'aquesta versió de la
  classe Cjt_estudiants, així com la definició dels camps privats. **És
  molt important** que la implementació de les operacions que us hem
  encarregat tingui en compte i preservi l'invariant de la representació
  de la classe `Cjt_estudiants`.

- `Cjt_estudiants.cc`: la implementació de totes de les operacions de la
  nova versió de la classe `Cjt_estudiants` tret de les operacions
  `afegir_estudiant` i `es­bo­rrar_es­tu­diant`.

- `Estudiant.hh`: l'especificació de la classe `Estudiant` i la
  definició dels seus atributs.

- `Estudiant.cc`: la implementació dels mètodes de la classe
  `Estudiant`.

- `pro2.cc`: un programa principal que podeu fer servir per provar les
  operacions públiques d'aquesta versió de la classe `Cjt_estudiants`.

- `llegeixme.txt`: instruccions per a generar l'executable del programa
  `pro2` i provar-lo.

- `sample.inp`: entrada del joc de proves públic

- `sample.cor`: sortida del joc de proves públic

- `solution.cc`: plantilla explicada previament

És fonamental que la solució sigui eficient en temps i espai. En
particular, s'han d'evitar instruccions innecessàries (especialment
bucles o crides a operacions costoses) i no es poden fer servir objectes
auxiliars de les classes vector o Cjt_estudiants. No es pot emprar cap
estructura de dades que no hagi aparegut a les sessions 1-4 de
laboratori.\
 \
Quan feu els enviaments el Jutge us indicarà quants jocs de proves
passeu i de quin tipus (public o privat). El joc de proves anomenat
`public` s'explica al fitxer `llegeixme.txt`. El `privat1` és molt
semblant al `public`. Els `privat2` i `privat3` proven situacions
especials.

## Informació del problema

Autoria: Professors de PRO2

Generació: 2026-01-25T14:23:21.513Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
