# Arbre de sumes

Implementeu una funció **RECURSIVA** que, donat un arbre binari
d'enters, retorna un nou arbre amb la mateixa estructura, i a on cada
posició conté la suma de nodes del subarbre que penja d'aquella mateixa
posició a l'arbre inicial. Aquesta és la capcelera:

    // Pre:
    // Post: Retorna un arbre d'enters amb la mateixa estructura que t,
    //       i a on cada subarbre té com a arrel la suma dels nodes del corresponent subarbre a t.
    BinaryTree<int> treeOfSums(BinaryTree<int> t);

Aquí tenim un exemple de paràmetre d'entrada de la funció i la
corresponent sortida:

    treeOfSums(3(1(,5),3(2(1,7),))) => 22(6(,5),13(10(1,7),))

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`Makefile, program.cpp, BinaryTree.hpp, treeOfSums.hpp`. Us falta crear
el fitxer `treeOfSums.cpp` amb els corresponents `includes` i
implementar-hi la funció anterior. Quan pugeu la vostra solució al
jutge, només cal que pugeu un tar construït així:


    tar cf solution.tar treeOfSums.cpp

## Entrada

L'entrada té un nombre arbitrari de casos. Cada cas consisteix en una
línia amb un string describint un arbre binari d'enters. Fixeu-vos en
que el programa que us oferim ja s'encarrega de llegir aquestes
entrades. Només cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent arbre de sumes.
Fixeu-vos en que el programa que us oferim ja s'encarrega d'escriure
aquesta sortida. Només cal que implementeu la funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema. En les
crides recursives, incloeu la hipòtesi d'inducció, és a dir una
explicació del que es cumpleix després de la crida, i també la funció de
fita/decreixement o una justificació de perquè la funció recursiva
acaba.

Molt possiblement, una solució directa serà lenta, i necessitareu crear
alguna funció recursiva auxiliar per a produïr una solució més eficient
capaç de superar tots els jocs de proves.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T21:03:42.824Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
