# Shikaku. Compta illa

En el joc del *Shikaku*, una **illa** es defineix com un grup de cel·les
que estan agrupades de manera que formen un quadrat o rectangle. Una de
les condicions que ha complir una **illa correcta** és que totes les
cel·les que pertanyen a aquesta illa tinguin el mateix identificador.

Fes una funció que compti el nombre de cel·les de la matriu `mat`
l'identificador de les quals és igual a `id` i pertanyen a la illa
definida per la cantonada superior esquerra`(f1, c1)` i la cantonada
inferior dreta `(f2, c2)`. En concret aquesta funció torna:

- el nombre de caselles de la illa que són iguals a `id` si la illa és
  correcta.

- $0$ si la illa no és correcta.

## Interfície

    unsigned int compta_illa(const Matriu &mat, char id, unsigned int f1, unsigned int c1,
    	unsigned int f2, unsigned int c2);

## Definició de tipus i tuples

La tupla `Casella` i el tipus `Matriu` estan definits de la següent
manera:

    // Casella d'un tauler de shikaku
    struct Casella {
    	char id = '0'; // Identificador de la casella
    			// Inv: id és una lletra majúscula o '0' (no té cap valor assignat). 
    	int num = 0;  // Nombre de caselles que ha de tenir la illa
    			// Inv: num > 0 (si la casella té un valor inicial) o num == 0 
    			//  (si la casella no té un valor inicial)
    };

    // Tauler de shikaku
    typedef vector<vector<Casella>> Matriu;

**[IMPORTANT]{style="color: red"}**: En la solució que enviïs a jutge
cal que al principi posis la declaració de la tupla `Casella` i el tipus
`Matriu` que et donem.

## Precondició

*mat* no és buida, $0 <= f1 <= f2 < mat.size()$ i
$0 <= c1 <= c2 < mat[0].size()$

## Observació

Has d'enviar la declaració de la tupla `Casella`, el tipus `Matriu` i la
funció requerida; el programa principal serà ignorat.

## Exemples

Donada la següent matriu `mat` (de la qual es mostra només
l'dentificador de cada cel·la):

    	A A A A A
    	A A A A A
    	B B B C 0
    	D D E F F
    	D D D 0 0

les següents crides a la funció generen el resultats indicats:

    compta_illa(mat, 'A', 0, 0, 1, 1) = 4
    compta_illa(mat, 'A', 0, 0, 2, 2) = 0
    compta_illa(mat, 'A', 0, 1, 1, 4) = 8
    compta_illa(mat, 'B', 2, 2, 2, 2) = 1
    compta_illa(mat, 'C', 2, 3, 2, 4) = 0
    compta_illa(mat, 'D', 3, 0, 4, 2) = 0

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T14:21:35.141Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
