#include <iostream>
#include <string>
#include <stack>
#include <sstream>

using namespace std;

stack<int> suma_piles(const stack<int> &p1, const stack<int> &p2);

#ifndef IOSTACKFUNCTIONS
#define IOSTACKFUNCTIONS

stack<int> readStack(const string &line) {
	istringstream mycin(line);
	stack<int> s;
	int x;
	while (mycin >> x) {
		s.push(x);
	}
	return s;
}

void readStack(const string &line, stack<int> &p1, stack<int> &p2) {
	int i1 = line.find('[');	
	int i2 = line.find(']', i1+1);	
	int i3 = line.find('[', i2+1);
	int i4 = line.find(']', i3+1);
	p1 = readStack(line.substr(i1+1, i2-i1-1));
	p2 = readStack(line.substr(i3+1, i4-i3-1));
}

void writeStackRec(stack<int> &s) {
	if (not s.empty()) {
		int x = s.top();
		s.pop();
    bool writespace = not s.empty();
    writeStackRec(s);
    if (writespace) cout << " ";
    cout << x;
  }
}

void writeStack(stack<int> s) {
	cout << '[';
	writeStackRec(s);
  cout << ']';
	cout << endl;
}

#endif

int main() {
	string l;
	while (getline(cin, l)) {
		stack<int> p1, p2;
		readStack(l, p1, p2);
		writeStack(suma_piles(p1, p2));
	}	
	return 0;
}
