# Circuit values

Verilog is a hardware description language to model digital circuits
that is standardized by IEEE. Write a program that, given the
description of a digital circuit in a simplified version of Verilog and
a sequence of truth assignments for the inputs to the circuit, outputs
the result of evaluating the circuit on those assignments.

![image](circuitet.png){width="10cm"}

## Input

Input starts with a sequence of output cable identifiers, followed by a
sequence of input cable identifiers, then a sequence of AND, OR or NOT
gate specifications, and finally a sequence of cases. Each case is a
truth-value assignment to the input cables of the circuit in the same
order as given in the description of the circuit. Each cable of the
circuit is identified by a unique sequence of lower-case letters and
digits. The truth values are `T` and `F` for TRUE and FALSE,
respectively.

Follow the format of the examples. You may assume that the input
describes a correct circuit; that is, input and output cables are
disjoint, all cables are reachable from the inputs, and the circuit does
not contain cycles (in particular, no input cable is the output of a
gate).

## Output

Output is the sequence of truth values that the circuit generates at its
output cables with each assignment, in the same order as given in the
description of the circuit, one per line.

## Problem information

Author: Unknown\
Translator: Albert Atserias

Generation: 2026-01-25T14:20:00.631Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
