# Implementació de matrius esparses

Cal implementar la classe `matriu <T>` i dues operacions en matrius: la
suma i el producte. Cal que implementeu la matriu com a vector de
llistes, com normalment es fa en matrius esparses. Una *matriu esparsa*
és una matriu que té moltes posicions amb el valor zero. D'aquesta
manera, per cada fila només tenim una llista que conté parells
`posicio, valor`, en què `posicio` indica el valor de la columna en què
es troba el valor.

Més formalment, tenim que les files es desen en un vector de parells
tals que per al parell (j,x) de la fila i:

$$x \neq 0 \Leftrightarrow m[i][j] = x \Leftrightarrow (j,x) \in files[i]$$

## Entrada

L'entrada consisteix en un codi d'operació, que pot ser 1 o 2 (1 = suma,
2 = producte) i dues matrius representades de forma esparsa.

Per cada matriu hi ha primer dos enters que representen les diemnsions
de la matriu, i després, per cada fila, hi ha el nombre `N` d'elements
de la fila. Si aquest número és zero, voldrà dir òbviament que tots els
elements de la fila són zero. Altrament, hi haurà `N` parelles
`posicio valor`.

## Sortida

La sortida és la suma o el producte de les dues matrius d'entrada segons
el codi d'entrada.

## Observació

Cal implementar les matrius com a vector de llistes de parells.

Cal enviar 1 sol fitxer: `matriu.tcc` com a fitxer `.tar`. Aquest fitxer
té la implementació de la classe `matriu`.

Per a implementar les funcions al fitxer `matriu.tcc` cal posar el
prefix `template <typename T> matriu <T>` a les capçaleres de cada
funció. Per exemple:

`template <typename T> int matriu <T>::num_columnes () const { ...`

Per a instanciar un iterador de la llista de *parint*, cal fer-ho així:

`typename list<parint>::iterator it`

A més, *cal no* declarar aquest iterador a dins d'in `for`. Per exemple,
aquesta és una manera *incorrecta* de declarar l'iterador:

`for (typename list<parint>::iterator it= it.begin() ...`

Cal fer-ho així:

`typename list<parint>::iterator it;`

`for (it= it.begin() ...`

## Informació del problema

Autoria: J. Baixeries

Generació: 2026-01-25T21:03:25.150Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
