# Reemplaça els valors dels nodes a profunditat parell en un arbre per la suma per sota

Implementeu una funció **RECURSIVA** que, donat un arbre binari
d'enters, retorna un nou arbre amb la mateixa estructura, i a on cada
posició a profunditat parell conté la suma de nodes del subarbre que
penja d'aquella mateixa posició a l'arbre inicial, i a cada posició a
profunditat senar hi ha exactament el mateix valor que es troba en
aquella posició a l'arbre inicial.

Sobreentenem que l'arrel de l'arbre està a profunditat 0, els nodes
directes des de l'arrel són a profunditat 1, els nodes a distància dos
de l'arrel són a profunditat 2, i així successivament. Aquesta és la
capcelera:

    // Pre:  Sigui T el valor inicial de t.
    // Post: Retorna un arbre d'enters R amb la mateixa estructura que T.
    //       Per a cada posició p de T i R, si p és a profunditat senar,
    //       llavors T i R tenen el mateix valor a posició p.
    //       En canvi, si p es a profunditat parell, llavors el valor de R a posició
    //       p és la suma de tots els valors que es troben a T a posició p o per sota.
    BinaryTree<int> SumBelowAtEvenDepth(BinaryTree<int> t);

Aquí tenim un exemple de paràmetre d'entrada de la funció i la
corresponent sortida:

    SumBelowAtEvenDepth(3(1(,5),3(2(1(3,6),7),))) => 31(1(,5),3(19(1(3,6),7),))

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`Makefile, program.cpp, BinaryTree.hpp, SumBelowAtEvenDepth.hpp`. Us
falta crear el fitxer `SumBelowAtEvenDepth.cpp` amb els corresponents
`includes` i implementar-hi la funció anterior. Quan pugeu la vostra
solució al jutge, només cal que pugeu un tar construït així:


    tar cf solution.tar SumBelowAtEvenDepth.cpp

## Entrada

L'entrada té un nombre arbitrari de casos. Cada cas consisteix en una
línia amb un string describint un arbre binari d'enters. Fixeu-vos en
que el programa que us oferim ja s'encarrega de llegir aquestes
entrades. Només cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent arbre de sumes.
Fixeu-vos en que el programa que us oferim ja s'encarrega d'escriure
aquesta sortida. Només cal que implementeu la funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema. En les
crides recursives, incloeu la hipòtesi d'inducció, és a dir una
explicació del que es cumpleix després de la crida, i també la funció de
fita/decreixement o una justificació de perquè la funció recursiva
acaba.

Una solució directa superarà els jocs de proves públics i us permetrà
obtenir una nota raonable. Però molt possiblement serà lenta, i
necessitareu crear alguna funció recursiva auxiliar per a produïr una
solució més eficient capaç de superar tots els jocs de proves.

Avaluació sobre 10 punts:

- Solució lenta: 6 punts.

- Solució lenta + justificació: 8 punts.

- solució ràpida: 8 punts.

- solució ràpida + justificació: 10 punts.

Entenem com a solució lenta una que és correcta i capaç de superar els
jocs de proves públics. Entenem com a solució ràpida una que és correcta
i capaç de superar els jocs de proves públics i privats. La justificació
val 1 punt i consisteix en definir correctament les PRE/POST de les
funcions auxiliars que afegiu i en definir correctament les hipòtesis
d'inducció i funcions de fita.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T21:02:57.633Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
