#include <sstream>
#include <math.h>
using namespace std;

template <typename Clau>
dicc<Clau>::dicc() : _arrel(NULL) {}

template <typename Clau>
dicc<Clau>::~dicc() {
  esborra_nodes(_arrel);
}

template <typename Clau>
void dicc<Clau>::insereix(const Clau &k) {
  _arrel = insereix_bst(_arrel, k);
}

template <typename Clau>
void dicc<Clau>::esborra_nodes(node* m) {
  if (m != NULL) {
    esborra_nodes(m->_esq);
    esborra_nodes(m->_dret);
    delete m;
  }
}

template <typename Clau>
dicc<Clau>::node::node (const Clau &k, node* esq, node* dret) :
	_k(k), _esq(esq), _dret(dret) {
}

template <typename Clau>
typename dicc<Clau>::node* dicc<Clau>::insereix_bst(node *n, const Clau &k) {
  if (n == NULL) {
    return new node(k);
  }
  else {
    if (k < n->_k) {
      n->_esq = insereix_bst(n->_esq, k);
    }
    else if (k > n->_k) {
      n->_dret = insereix_bst(n->_dret, k);
    }
    return n;
  }
}

template <typename Clau>
void dicc<Clau>::print() const {
  print(_arrel);
}

template <typename Clau>
void dicc<Clau>::print(node* n) {
  if (n != NULL) {
    print(n->_esq);
    cout << n->_k << " ";
    print(n->_dret);
  }
}

template <typename Clau>
nat dicc<Clau>::mida() const {
  return mida(_arrel);
}

template <typename Clau>
nat dicc<Clau>::mida(node* n) {
  nat m = 0;
  if (n != NULL) {
    m = 1 + mida(n->_esq) + mida(n->_dret);
  }
  return m;
}

template <typename Clau>
nat dicc<Clau>::altura() const {
  return altura(_arrel);
}

template <typename Clau>
nat dicc<Clau>::altura(node* n) {
  nat h = 0;
  if (n != NULL) {
    h = 1 + max(altura(n->_esq), altura(n->_dret));
  }
  return h;
}


int main() {
  string linea;
  int n;

  // Obtenim d1
  dicc<int> d1;
  getline(cin, linea);
  istringstream ss1(linea);
  while (ss1 >> n) {
    d1.insereix(n);
  }

  // Obtenim d2
  dicc<int> d2;
  getline(cin, linea);
  istringstream ss2(linea);
  while (ss2 >> n) {
    d2.insereix(n);
  }

  dicc<int> dr;
  d1.diferencia(d2, dr);
  dr.print();
  cout << endl;
  nat mida = dr.mida();
  nat altura = dr.altura();
  if (altura <= min(mida, (nat)log2(mida)*10))
    cout << "BST suficient balancejat\n";
  else
    cout << "BST poc balancejat\n";

  // cout << d1.mida() << " " << d2.mida() << " " << mida << endl;
  // cout << d1.altura() << " " << d2.altura() << " " << altura << endl;
  // cout << min(mida, (nat)log2(mida)*10);
  return 0;
}
