# Creació d'un BST diferència de dos BSTs

Donada la classe $dicc$ que permet gestionar diccionaris on només hi
guardem claus úniques usant arbres binaris de cerca (BST), cal
implementar el mètode

      void diferencia(const dicc<Clau> &d2, dicc<Clau> &dr) const;
      // Pre: El diccionari dr està buit
      // Post: dr conté les claus de la diferència del p.i. amb d2

Les claus són del tipus $Clau$ que admet una relació d'ordre total, és a
dir, tenim una operació de comparació $<$ entre claus.

Cal enviar a jutge.org la següent especificació de la classe $dicc$ i la
implementació del mètode dins del mateix fitxer. La resta de mètodes
públics i privats ja estan implementats. Indica dins d'un comentari a la
capçalera del mètode el seu cost en funció del nombre d'elements $n1$
del diccionari del p.i. i nombre d'elements $n2$ del diccionari $d2$.

    #include <iostream>
    using namespace std;
    typedef unsigned int nat;

    template <typename Clau>
    class dicc {

      public:
        // Constructora per defecte. Crea un diccionari buit.
        dicc();

        // Destructora
        ~dicc();

        // Insereix la clau k en el diccionari. Si ja hi era, no fa res.
        void insereix(const Clau &k);

        // Imprimeix els elements del diccionari ordenats de menor a major
        void print() const;

        // Retorna la mida del BST que implementa el diccionari
        nat mida() const;

        // Retorna l'altura del BST que implementa el diccionari
        nat altura() const;

        void diferencia(const dicc<Clau> &d2, dicc<Clau> &dr) const;
        // Pre: El diccionari dr està buit
        // Post: dr conté les claus de la diferència del p.i. amb d2

      private:
        struct node {
          Clau _k;      // Clau
          node* _esq;   // fill esquerre
          node* _dret;  // fill dret
          node(const Clau &k, node* esq = NULL, node* dret = NULL);
        };
        node *_arrel;

        static void esborra_nodes(node* m);
        static node* insereix_bst(node *n, const Clau &k);
        static void print(node *n);
        static nat mida(node *n);
        static nat altura(node *n);

        // Aquí va l'especificació dels mètodes privats addicionals
    };

    // Aquí va la implementació dels mètodes públics i privats

Degut a que jutge.org només permet l'enviament d'un fitxer amb la
solució del problema, en el mateix fitxer hi ha d'haver l'especificació
de la classe i la implementació del mètode $diferencia$ (el que
normalment estarien separats en els fitxers $.hpp$ i $.cpp$).

Per testejar la classe disposes d'un programa principal que llegeix dos
diccionaris d'enters, desprès crida el mètode $diferencia$ i finalment
mostra el contingut del diccionari amb la diferència dels dos
diccionaris inicials. També s'indica si el BST del diccionari resultant
està suficientment balancejat.

## Entrada

L'entrada conté dues línies formades per seqüències d'enters, són els
elements que tindran els dos diccionaris inicials.

## Sortida

A la sortida apareixen ordenats i separats per espais, els elements del
diccionari resultant que conté la diferència dels dos diccionaris
inicials. A la segona línia apareix el text \"BST poc balancejat\" o
\"BST suficient balancejat\", depenen de si l'altura del BST resultant
supera o no $min
(mida, log_2(mida) * 10)$, sent $mida$ el nombre de nodes de l'arbre
resultant.

## Observació

Només cal enviar l'especificació de la classe $dicc$, la implementació
del mètode $diferencia$ i el seu cost en funció del nombre d'elements
$n1$ i $n2$ dels dos diccionaris inicials. Pots ampliar la classe amb
mètodes privats. Segueix estrictament la definició de la classe de
l'enunciat.

Primer cal crear un BST amb el resultat correcte. Posteriorment cal
obtenir un BST més balancejat si no ho està suficientment. Hi ha
diferents tècniques per aconseguir-ho, una d'elles és alternar de forma
aleatòria l'ordre en que es recorren els BSTs inicials (esquerra-dreta o
dreta-esquerra), et pot ser d'utilitat l'expressió $rand() \% 2$ que
simula el cara/creu d'una moneda llançada a l'aire, el seu resultat és
$0$ o $1$.

Els primers tres exemples mostren la diferència de dos diccionaris buits
o un de buit i un que no ho és.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T14:12:26.408Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
