# Afegir elements a una Queue només si continua siguent creixent.

En aquest exercici modificarem el mètode `push` de la classe `Queue` per
tal d'assegurar que els seus elements estan sempre ordenats de forma
estríctament creixent des del principi fins el final de la cua. El canvi
és molt senzill: en una crida a `push`, si afegir l'element provocarà
que la `Queue` deixi de ser estríctament creixent, llavors aquest
element s'ignora i no s'afegeix.

Per exemple, suposeu que la `Queue` `q` conté els elements $[1,3,6]$ (on
els elements els representem en ordre des del front fins el final, i en
particular $6$ és l'últim element de la cua), i que es fa una crida
`q.push(4)`. Llavors, `q` no haurà canviat i continuarà contenint
$[1,3,6]$. Una crida `q.push(6)` tampoc provocarà cap canvi. Però una
crida `q.push(7)` provocarà que `q` passi a contenir $[1,3,6,7]$.

D'entre els fitxers que s'adjunten en aquest exercici, trobareu
`queue.hh`, a on hi ha una implementació de la classe genèrica `Queue`.
Haureu de buscar dins `queue.hh` la implementació del mètode `push` i
adaptar-lo convenientment.

Podeu suposar que el tipus genèric `T` de la classe té predefinida la
operació de comparació `<`. Fins i tot, si voleu, poseu suposar que
també teniu `>, <=, >=`, tot i que realment no cal. De fet, es testejarà
la vostra implementació amb el tipus `T=int`. Ara bé, una solució que no
sigui genèrica es considerarà incorrecta i serà invalidada a posteriori,
encara que superi els jocs de proves.

D'entre els fitxers que s'adjunten a l'exercici també hi ha `main.cc`
(programa principal), i el podeu compilar directament, doncs fa include
de `queue.hh`. Només cal que pugeu `queue.hh` al jutge.

## Entrada

L'entrada del programa comença amb una declaració d'unes quantes cues
d'enters (`q0, q1, ...`), i després té una seqüència de comandes sobre
les cues declarades. Com que ja us oferim el `main.cc`, no cal que us
preocupeu d'implementar la lectura d'aquestes entrades. Només cal que
implementeu la extensió de la classe cua abans esmentada.

Se suposa que la seqüència d'entrada serà correcta (sense pop ni front
sobre cua buida).

El programa principal que us oferim ja s'encarrega de llegir aquestes
entrades i fer les crides als corresponents mètodes de la classe cua.
Només cal que feu els canvis abans esmentats.

## Sortida

Per a cada comanda d'escriptura sobre la sortida s'escriurà el resultat
corresponent. El `main.cc` que us oferim ja fa això. Només cal que
implementeu la extensió de la classe cua abans esmentada.

## Observació

Avaluació sobre 10 punts: (Afegiu comentaris si el vostre codi no és
prou clar)

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta i capaç de superar els
jocs de proves públics i privats. Entenem com a solució lenta una que no
és ràpida, però és correcta i capaç de superar els jocs de proves
públics.

Una solució que no sigui genèrica (per a qualsevol tipus T amb \<, \>,
\<=, \>=) serà invalidada i rebrà nota 0, encara que superi els jocs de
proves.

Una solució que crei memòria innecessàriament rebrà una penalització, i
aquesta penalització serà fins i tot major si a sobre aquesta memòria
innecessària no s'allibera, encara que superi els jocs de proves.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-27T18:51:32.730Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
