# Ordenació eficient d'una llista doblement encadenada, no circular i sense fantasma

Donada la classe $Llista$ que permet guardar seqüències d'enters amb una
llista doblement encadenada, NO circular i sense fantasma, cal
implementar el mètode

    void ordena()

que ordena eficientment els elements del paràmetre implícit de major a
menor. No es poden usar estructures de dades auxiliars com els vectors o
arrays.

Cal enviar a jutge.org la següent especificació de la classe $Llista$ i
la implementació del mètode dins del mateix fitxer. Al principi de cada
mètode implementat, dins d'un comentari, cal indicar el cost temporal
amb el raonament corresponent, incloent l'equació de la recurrència si
fos necessari.

    #include <cstddef>
    #include <vector>
    using namespace std;
    typedef unsigned int nat;

    class Llista {
      // Llista doblement encadenada, no circular i sense fantasma.

      public:
        Llista();
        // Pre: True
        // Post: El p.i. és una llista buida.

        Llista(const vector<int> &v);
        // Pre: True
        // Post: El p.i. conté els elements de v amb el mateix ordre.

        ~Llista();
        // Post: Destrueix els elements del p.i.

        nat longitud() const;
        // Pre: True
        // Post: Retorna el nombre d'elements del p.i.

        void mostra() const;
        // Pre: True
        // Post: Mostra el p.i. pel canal estàndard de sortida.

        void mostra_invertida() const;
        // Pre: True
        // Post: Mostra el p.i. en ordre invers pel canal estàndard de sortida.

        void ordena();
        // Pre: True
        // Post: S'han ordenat eficientment els elements del p.i. de major a menor

      private:
        struct node {
          int info;  // Informació del node
          node *seg; // Punter al següent element
          node *ant; // Punter a l'anterior element
        };
        node *_prim; // Punter al primer element
        node *_ult;  // Punter a l'últim element
        nat _long;   // Nombre d'elements

        // Aquí va l'especificació dels mètodes privats addicionals
    };

    // Aquí va la implementació del mètode ordena i privats addicionals

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $Llista$ i un programa principal que processa
línies d'enters amb els que crea llistes i desprès crida el mètode
$ordena$.

## Entrada

L'entrada conté vàries línies formades per seqüències d'enters.
Cadascuna d'elles són els elements que tindrà cada llista.

## Sortida

Per a cada línia d'entrada, escriu una línia amb el resultat desprès
d'haver ordenat els elements: El nombre d'elements de la llista seguit
d'un espai, els elements de la llista entre claudàtors i separats per
espais, i finalment aquests mateixos elements però amb ordre invers,
també entre claudàtors i separats per espais.

## Observació

Només cal enviar la classe requerida i la implementació del mètode
$ordena$. Pots ampliar la classe amb mètodes privats. Segueix
estrictament la definició de la classe de l'enunciat. No es poden usar
estructures de dades auxiliars com els vectors o arrays.

Al principi de cada mètode implementat i dins d'un comentari cal indicar
el cost temporal amb el raonament corresponent, incloent l'equació de la
recurrència si fos necessari.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T14:06:08.789Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
