# Número de c's con a antes sin b en medio, y número de d's con a después sin b en medio

La entrada de este ejercicio es una secuencia de caracteres sobre
`{a,b,c,d}`. Queremos contar dos cosas:

- Queremos contar el número de `c`'s que cumplen lo siguiente: antes de
  esta `c` hay alguna `a`. Además, si consideramos la `a` más cercana a
  esta `c` y anterior a esta `c`, entonces, entre ambas letras no hay
  ninguna `b`. Por ejemplo, en la siguiente palabra hemos marcado en
  negrita las `c`'s que se han de contar:
  `cdbdad`**`c`****`c`**`bdca`**`c`**`bbdcdabcd`.

- Queremos contar el número de `d`'s que cumplen lo siguiente: después
  de esta `d` hay alguna `a`. Además, si consideramos la `a` más cercana
  a esta `d` y posterior a esta `d`, entonces, entre ambas letras no hay
  ninguna `b`. Por ejemplo, en la siguiente palabra hemos marcado en
  negrita las `d`'s que se han de contar:
  `cdb`**`d`**`adccb`**`d`**`cacbb`**`d`**`c`**`d`**`abcd`.

## Entrada

La entrada es una secuencia de caracteres sobre `{a,b,c,d}`, en una sola
linea.

## Salida

La salida tiene dos números naturales, en una sola linea, y separados
por un espacio en blanco:

- el número de `c`'s que tienen una `a` antes y no hay ninguna `b` entre
  ambas letras.

- el número de `d`'s que tienen una `a` después y no hay ninguna `b`
  entre ambas letras.

## Observación

No se puede utilizar ningún método de almacenamiento masivo de datos, ni
tan siquiera `string`. Leed y tratad la entrada carácter a carácter.

Evaluación sobre 10 puntos:

- Solución lenta: 5 puntos.

- solución rápida: 10 puntos.

Entendemos como solución rápida una que es correcta, de coste lineal y
capaz de superar los juegos de pruebas públicos y privados. Entendemos
como solución lenta una que no es rápida, pero es correcta y capaz de
superar los juegos de pruebas públicos.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T14:02:03.825Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
