# Area of union of circles

We want to calculate the area of the union of a set of circles. This is
a problem that has some non-trivial algorithm for the exact computation.
Instead, we would be satisfied by finding an approximation using a
Montecarlo method. The ideas is as follows:

- Calculate a bounding box around the circles.

- Generate random points within the bounding box.

- Count how many points are inside some circle.

![image](cercles){width="15cm"}

## Input

The input contains a set of cases. Each case specifies the number of
circles, $n\geq 0$, and the number of random points generated for the
Montecarlo approximation. After that, a list of $n$ circles is
specified, each one with the coordinates of the center, $(x,y)$, and the
radius. The coordinates and the radius are real numbers.

## Output

For every case print the estimated area as a real number in free format.

## Observation

There is no need to compute the exact area. The output will be
considered correct if it is a good approximation of the area.

## Problem information

Author: Jordi Cortadella

Generation: 2026-01-25T14:00:32.275Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
