# Molecules with numbers

As you know, some molecules include digits as part of their chemical
formula, like H2O, whereas others don't, like NaCl.

Your program must process a sequence of molecules; it should ignore all
molecules without numbers inside the chemical formula and, of the rest,
it must report the most frequent formula(s) among those coming in the
sequence before the first occurrence of NaCl (which is ignored from the
counting as it does not have digits but, of course, is not ignored as an
endmark).

## Input

Input is a sequence of molecules. There is no information about whether
they are organized in lines nor, if so, how. It is guaranteed that there
is at least one occurrence of the molecule NaCl and that, before it,
there is at least one occurrence of molecules with digits in their
formula.

## Output

Your program must print the most frequent molecule found in the sequence
before the first occurrence of NaCl, under the condition that only
molecules with numbers in their formula are to be considered. Molecules
whose formulas contain just letters are to be ignored, except for the
endmarker NaCl. In case of a tie, your program must output all the tied
molecules, ordered from smaller ones to larger ones according to
Python3's str ordering. All molecules printed out must be each on a line
with no extra spaces or lines.

## Problem information

Author: José Luis Balcázar

Generation: 2026-01-25T13:58:39.495Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
