# Arbre binari creixent

Feu una funció tal que, donat un arbre binaris, torni `true` si i només
si és un **arbre creixent**.

Un arbre és **creixent** si i només si el valor de l'arrel és
**estrictament inferior** a tots els valors que hi ha en els nodes que
en pengen.

Per exemple, aquest dos arbres són creixents

                            1          4
                           / \        / \
                          3   8      5   6
                         / \        / \
                        4   6      6   9

En canvi, aquests dos no ho són:

                            1          1
                           / \        / \
                          3   8      3   3
                         / \        / \   \
                        2   6      8   6   2

La funció que heu de programar és:

`bool arbreCreixent (arbreBin<int>&);`

i l'heu de posar al fitxer `arbreCreixent.cpp`.

Tingueu en compte que la gestió d el'entrada i la sortida la fa el
programa principal que ja us passem. Només cal que programeu la funció i
prou.

## Entrada

Un arbres amb el següent format: la mida de l'arbre i els nodes en
postordre d'un arbre binari; per cada node s'indica el seu valor i el
nombre de fills.

## Sortida

`SI` (sense accent) si l'arbre és creixent, `NO` altrament.

## Observació

Heu d'enviar la solució comprimida en un fitxer .tar:

`tar cvf program.tar arbreCreixent.cpp`

Observeu que per compilar us donem el `Makefile`, la classe
`arbreBin.hpp`, la capçalera del mòdul funcional `arbreCreixent.hpp` i
el programa principal `program.cpp`.

Jutge.org també us donarà un semàfor verd si envieu una solució
iterativa, però no serà correcte ja que l'enunciat del problema demana
que la solució enviada sigui **recursiva**.

## Informació del problema

Autoria: PRO1-Vilanova

Generació: 2026-01-25T20:37:02.832Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
