# Intervals de notes dels estudiants d'un conjunt

Hem decidit estendre la classe `Cjt_estudiants` que heu vist al
laboratori amb una nova funcionalitat: obtenir el nombre d'estudiants
dins un interval de notes.

Les notes dels estudiants es classifiquen en 10 intervals, identificats
amb nombres del 0 al 9. L'interval 0 comprèn les notes més grans o
iguals que 0 y menors que 1, l'interval 1 cobreix les notes més grans o
iguals que 1 y menors que 2 i així successivament. Suposarem que la nota
màxima (10) pertany a l'interval 9. La nota dels alumnes no presentats
no pertany a cap interval.

Hem optat per afegir una nova operació pública amb la següent
especificació:

    int nombre_est_interval(int i) const;
    /* Pre: 0 <= i <= 9 */
    /* Post: el resultat és el nombre d'estudiants del paràmetre implícit amb nota a l'interval i */

Això ha suposat afegir un atribut nou a la classe. Tenint això en
compte, només heu d'implementar eficientment les següents operacions:

    void afegir_estudiant(const Estudiant &est, bool& b);
    /* Pre: el paràmetre implícit no està ple */
    /* Post: b = indica si el p.i. original conté un estudiant amb el dni d'est;
       si b = fals, s'ha afegit l'estudiant est al paràmetre implícit */

    void esborrar_estudiant(int dni, bool& b);
    /* Pre: cert */
    /* Post: b indica si el paràmetre implícit original tenia un estudiant 
       amb el dni dni; si b, aquest estudiant ha quedat eliminat
       del paràmetre implícit */

    void incrementar_interval(double x);
    /* Pre: x és una nota vàlida */
    /* Post: al paràmetre implícit, s'ha incrementat en una unitat el valor de
       la posició d'"intervals" corresponent a x */

    void decrementar_interval(double x);
    /* Pre: x és una nota vàlida */
    /* Post: al paràmetre implícit, s'ha decrementat en una unitat el valor de
       la posició d'"intervals" corresponent a x */

## Observació

Heu de lliurar un fitxer `solucio.cc` amb una implementació eficient
d'aquestes quatre operacions i començant per:

    #include "Cjt_estudiants.hh"

El vostre `solucio.cc` no pot contenir la implementació d'altres
operacions de la classe.

A l'apartat *Public files* del Jutge us proveïm amb material addicional
comprimit en un fitxer .tar. Podeu descomprimir aquest fitxer amb la
comanda

       tar -xvf nom_fitxer.tar

Aquest material addicional consisteix en els següents fitxers:

- `Cjt_estudiants.hh`: l'especificació Pre/Post de totes les operacions
  públiques i privades d'aquesta nova versió de la classe
  `Cjt_estudiants`, així como la definició dels camps privats. Fixeu-vos
  que hi ha un atribut nou: un vector `intervals`, que conté el nombre
  d'estudiantes de cada interval. Aquest atribut ens ha permès
  implementar amb la màxima eficiència l'operació `nombre_est_interval`
  i cal actualitzar-lo en les operacions modificadores de la classe.
  **És molt important que la implementació de les operacions que us hem
  encarregat tingui en compte i preservi l'invariant de la representació
  de la classe `Cjt_estudiants`**. Fixeu-vos també que hem afegit les
  operacions, `incrementar_interval` i `decrementar_interval`
  `afegir_estudiant` i `esborrar_estudiant`

- `Cjt_estudiants.cc`: la implementació de totes les operacions de la
  nova versió de la classe `Cjt_estudiants` tret de les quatre
  operacions que heu d'implementar

- `Estudiant.hh`: l'especificació de la classe `Estudiant` que farem
  servir en aquest exercici i la definició dels seus atributs.

- `Estudiant.cc`: la implementació dels mètodes de la classe `Estudiant`

- `pro2.cc`: un programa principal que podeu fer servir per provar les
  operacions públiques d'aquesta versió de la classe ` Cjt_estudiants`

Valorarem positivament que la solució no contingui instruccions
(especialment bucles o crides a operacions costoses) ni objectes
(especialment vectors o conjunts) innecessaris. No es pot emprar cap
altre contenidor de STL ni arbres\
 \
Quan feu els enviaments el Jutge us indicarà quants jocs de proves
passeu i de quin tipus (public o privat).

## Informació del problema

Autoria: Professors de PRO2

Generació: 2026-01-25T13:41:37.645Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
