# Control PRO2 - Torn 2 (Primavera 2018)

Hem decidit estendre la classe `Cjt_estudiants` que heu vist al
laboratori amb dues noves funcionalitats.

La primera funcionalitat calcula la nota de laboratori, la nota de
teoria i la nota global d'un estudiant en una assignatura a partir de
les seves notes en els exàmens parcials d'aquesta assignatura, i assigna
les notes de laboratori, teoria i global calculades a aquest estudiant.
Les notes de laboratori, teoria i global d'un estudiant poden ser $-1$,
si es considera que la qualificació de l'estudiant en aquest aspecte de
l'assignatura ha de ser NP (No Presentat) o un valor real en el rang
`[0 …Estudiant::nota_maxima()]`, que correspon a: 1) la mitjana de les
notes dels exàmens parcials de laboratori en el cas de la nota de
laboratori; 2) la mitjana de les notes dels exàmens parcials de teoria
en el cas de la nota de teoria, i 3) la mitjana de la nota de laboratori
i de la nota de teoria en el cas de la nota global de l'assignatura. Per
realitzar l'avaluació global dels estudiants d'una assignatura, la
classe ` Cjt_estudiants` necessita representar certa informació sobre
aquesta assignatura, en particular, el nombre d'exàmens parcials que es
realitzen en l'assignatura, el subconjunt dels exàmens parcials que
contribueixen a la nota de laboratori, i el subconjunt dels exàmens
parcials que contribueixen a la nota de teoria. Per aquest motiu, hem
afegit cinc atributs nous a la classe `Cjt_estudiants`: (1)
` nombre_parcials` de tipus enter, que representa el nombre total
d'exàmens parcials de l'assignatura; (2) `nlab` de tipus enter, que
representa el nombre d'exàmens parcials que contribueixen a la nota de
laboratori; (3) ` lab` de tipus `vector`$<$`bool`$>$, que permet
representar el subconjunt dels exàmens parcials que contribueixen a la
nota de laboratori; (4) `nteo` de tipus enter, que representa el nombre
d'exàmens parcials que contribueixen a la nota de teoria, i (5)
` teoria` de tipus `vector`$<$`bool`$>$, que permet representar el
subconjunt dels exàmens parcials que contribueixen a la nota de teoria.
En aquesta representació del tipus `Cjt_estudiants` assumim que
l'identificador del $j$-èsim examen parcial d'una assignatura és $j$.
Per tant, els vectors `lab` i `teoria` esmentats anteriorment
representen dos subconjunts disjunts del conjunt d'enters
$\{1, \ldots, \mbox{nombre\_parcials} \}$, que contenen respectivament
els identificadors dels exàmens parcials de laboratori i dels exàmens
parcials de teoria.

Concretament, l'avaluació global d'un estudiant es realitza de la manera
següent. Si un estudiant no s'ha presentat a cap dels exàmens parcials
de laboratori, la seva nota de laboratori és -1 (que és el valor
escollit per representar la qualificació "No Presentat" en la nostra
implementació del tipus `Cjt_estudiants`). En un altre cas, la nota de
laboratori és la suma de les notes de l'estudiant en els exàmens
parcials de laboratori als quals s'ha presentat dividida pel nombre
d'exàmens parcials de laboratori (`nlab`) de l'assignatura. De la
mateixa manera, si un estudiant no s'ha presentat a cap dels exàmens
parcials de teoria, la seva nota de teoria és -1 (i.e., No Presentat).
En un altre cas, la nota de teoria és la suma de les notes de
l'estudiant en els exàmens parcials de teoria als quals s'ha presentat
dividida pel nombre d'exàmens parcials de teoria (` nteo`) de
l'assignatura. Finalment, la nota global d'un estudiant en l'assignatura
és -1 (i.e., No Presentat) si la seva nota de laboratori és -1 o la seva
nota de teoria és -1. En un altre cas, la nota global és simplement la
mitjana de la nota de laboratori de l'estudiant en l'assignatura i de la
seva nota de teoria en l'assignatura. Aquesta funcionalitat s'implementa
a la classe `Cjt_estudiants` mitjançant el mètode privat

      void avaluacio_global_iesim(int i);
      /* Pre:  1 <= i <= mida()
         L'estudiant i-èsim té notes assignades per a tots els exàmens parcials 
         de l'assignatura. La nota de cada examen parcial pot ser -1, si 
         l'estudiant no s'ha presentat a aquest examen parcial, o una nota vàlida 
         en el rang [0...Estudiant::nota_maxima()]. */
      /* Post: L'estudiant i-èsim passa a tenir assignades les seves notas de 
         laboratori, teoria i global en l'assignatura, que poden ser -1, si es 
         considera que la seva qualificació ha de ser NP (No Presentat), o una 
         nota vàlida en el rang [0...Estudiant::nota_maxima()] que correspon a: 
         1) la suma de les notes de l'estudiant en els exàmens parcials de 
         laboratori als quals s'ha presentat dividida pel nombre d'exàmens 
         parcials de laboratori de l'assignatura (nlab) en el cas de la nota de 
         laboratori; 2) la suma de les notes de l'estudiant en els exàmens 
         parcials de teoria als quals s'ha presentat dividida pel nombre 
         d'exàmens parcials de teoria de l'assignatura (nteo) en el cas de la 
         nota de teoria; i 3) la mitjana de la nota de laboratori i de la nota 
         de teoria en el cas de la nota global de l'assignatura. */

Per exemple, si $c$ és un objecte de la classe `Cjt_estudiants` que
representa els estudiants d'una assignatura amb $5$ exàmens parcials,
dels quals $3$ exàmens parcials són de laboratori i 2 són de teoria, els
identificadors dels exàmens parcials de laboratori són $\{1, 3, 4\}$,
els identificadors dels exàmens parcials de teoria són $\{2, 5\}$ i les
notes en els exàmens parcials del cinquè estudiant de $c$ són
`{-1, 9, -1, -1, 8 }`. Després de la crida
` c.avaluacio_glo­bal_iesim(5)`, la nota de laboratori del cinquè
estudiant de $c$ ha de ser -1 (i.e., No Presentat), la seva nota de
teoria ha de ser 8.5 i la seva nota global -1 (i.e., No Presentat). De
la mateixa manera, si les notes en els exàmens parcials del quart
estudiant de $c$ són `{-1, 9.75, 9.75, 5, -1}`, després de la crida
`c.avaluacio_global_iesim(4)`, la nota de laboratori del quart estudiant
de $c$ ha de ser 4.92, la seva nota de teoria 4.88 i la seva nota global
4.9.

La segona funcionalitat afegida a la classe `Cjt_estudiants` calcula i
escriu al canal estàndard de sortida el subconjunt d'exàmens parcials
als quals no s'ha presentat algun estudiant que ha aprovat
l'assignatura, és a dir, algun estudiant el qual té una nota global en
l'assignatura més gran o igual que $5$. Aquesta funcionalitat
s'implementa a la classe `Cjt_estudiants` mitjançant el mètode públic

      void parcials_no_presentats_aprovats() const;
    /* Pre: Tots els estudiants del paràmetre implícit tenen notes assignades 
       per a tots els exàmens parcials i també tenen assignada la seva nota 
       global en l'assignatura. La nota global i la nota de cada examen parcial 
       poden ser -1, si l'estudiant té la qualificació global No Presentat o 
       si no s'ha presentat a l'examen parcial, o una nota vàlida en el rang 
       [0...Estudiant::nota_maxima()]. */ 
     /* Post: Al canal de sortida estàndard s'han escrit els identificadors 
        dels exàmens parcials als quals no s'ha presentat algun estudiant 
        aprovat en l'assignatura, és a dir, algun estudiant que té una nota 
        global en l'assignatura més gran o igual que 5. Els identificadors 
        d'aquests exàmens parcials estan ordenats en ordre creixent. */

Per exemple, si $c$ és un objecte de la classe `Cjt_estudiants` que
representa els estudiants d'una assignatura amb $5$ exàmens parcials en
què hi ha exactament $4$ estudiants $\{e_{i_1}, \ldots ,
e_{i_ {4}}\}$ amb una nota global més gran o igual que $5$, i sabem que
d'aquests $4$ estudiants $e_ {i_3}$ no s'ha presentat ni al primer ni al
cinquè exàmens parcials, i $e_{i_4}$ no s'ha presentat ni al primer ni
al quart exàmens parcials, després de la crida
` c.parcials_no_presentats_aprovats()` es mostrarà en la pantalla el
subconjunt $\{1, 4, 5\}$, ja que com a mínim un estudiant aprovat no
s'ha presentat a aquests exàmens parcials.

Per implementar aquestes funcionalitats hem modificat també la
representació de la classe `Estudiant` de la manera descrita a l'arxiu
`Estudiant.hh`. En particular, representem les notes d'un estudiant en
quatre atributs nous: (1) `nota_lab` de tipus ` double`; (2)
`nota_teoria` de tipus `double`; (3) ` nota_global` de tipus `double`, i
(4) `notes_parcials` de tipus\
`vector`$<$`double`$>$. Concretament, la nota de l'examen parcial
$j$-èsim de l'estudiante paràmetre implícit és `notes_parcials[j-1]` per
a tot $j$ en el rang $1 \le j \le \mbox{notes\_parcials.size()}$.

## Observació

Tenint en compte tot això, heu d'implementar eficientment el mètode
privat\
`avaluacio_global_iesim` i el mètode públic
` parcials_no_presentats_aprovats`.\
Heu de lliurar un arxiu ` solucio.cc` amb una implementació eficient
d'aquests dos mètodes. En el cas del mètode públic
`parcials_no_presentats_aprovats`, podeu completar la implementació
parcial que us proposem o implementar aquest mètode sense utilitzar la
implementació parcial proposta.

És possible superar alguns jocs de prova (però no tots) **implementant
únicament el mètode privat ` avaluacio_global_iesim`**, sempre que no
modifiqueu la implementació parcial del mètode públic
`parcials_no_presentats_aprovats` de què us proveïm.

Dins del material addicional de què us proveïm a l'apartat *Public
files* del problema del jutge trobareu l'arxiu `plantilla.txt` amb les
capçaleres de tots dos mètodes i una implementació incompleta del mètode
`parcials_no_presentats_aprovats`: n'heu de canviar el nom de manera que
es digui `solucio.cc`, completar-lo i lliurar-lo al jutge.

El vostre fitxer `solucio.cc` no pot contenir la implementació d'altres
mètodes de les classes `Estudiant` o `Cjt_estudiants`.

A l'apartat *Public files* del jutge us proveïm de material addicional
en un fitxer .tar. Podeu extreure el contingut d'aquest fitxer amb la
instrucció

       tar -xvf nom_fitxer.tar

Aquest material addicional conté els fitxers següents:

- `plantilla.txt`: és la plantilla del fitxer solucio.cc; heu de canviar
  el nom d'aquest fitxer de manera que es digui `solucio.cc`,
  completar-lo i lliurar-lo al jutge

- `Cjt_estudiants.hh`: l'especificació Pre/Post de tots els mètodes
  públics i privats d'aquesta nova versió de la classe
  ` Cjt_estudiants`, així com la definició dels atributs privats.

- `Cjt_estudiants.cc`: la implementació de tots els mètodes de la classe
  `Cjt_estudiants`, tret de les dels mètodes que us demanem.

- `Estudiant.hh`: l'especificació de la nova versió de la classe
  `Estudiant` i la definició dels seus atributs privats.

- `Estudiant.cc`: la implementació de tots els mètodes de la classe
  `Estudiant`.

- `pro2.cc`: un programa principal que podeu fer servir per provar els
  mètodes públics d'aquesta nova versió de la classe ` Cjt_estudiants`.

- `entrada.txt` i `sortida_correcta.txt`: fitxer d'entrada del joc de
  proves públic, i sortida correcta per a aquest joc.

- `llegeixme.txt`: instruccions per a generar l'executable del programa
  `pro2.cc` i provar-lo.

Valorarem positivament que la solució no contingui instruccions
innecessàries (especialment bucles o crides a operacions costoses), ni
objectes innecessaris (especialment vectors o matrius), que no faci
recorreguts quan hauria de fer cerques, i que usi correctament les
operacions més adients de les classes `Estudiant` i ` Cjt_estudiants`,
sempre que sigui possible. No es pot usar cap estructura de dades que no
hagi aparegut a les sessions 1 a 4 de laboratori.

Quan feu els enviaments, el jutge us indicarà quants jocs de proves
supera el vostre programa i de quin tipus (públic o privat). **Tingueu
en compte que és possible superar alguns jocs de prova (però no tots)
implementant únicament el mètode `avaluacio_global_iesim`, si no
modifiqueu la implementació parcial del mètode
` parcials_no_presentats_aprovats` que us proporcionem**.

## Informació del problema

Autoria: Professors de PRO2

Generació: 2026-01-25T13:40:49.976Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
