# Posició d'un element en un arbre

Implementeu una funció **RECURSIVA** que, donat un arbre binari d'enters
`t` no repetits, i un enter `x`, retorna una llista amb els elements que
es troben en el camí des de l'arrel fins la posició de `x` a `t`. En cas
que `x` no pertanyi a l'arbre, la llista retornada serà buida. Aquesta
és la capcelera:

    // Pre:  t no té repetits
    // Post: retorna la llista de valors que es troben en el camí des de l'arrel
    //       fins la posició de x en t. En cas que x no es trobi a t, retorna
    //       una llista buida.
    list<int> posInTree(const BinaryTree<int> t, int x);

Aquí tenim un exemple de paràmetres entrada i sortida de la funció:

    t=                3
                      |
               ------- -------
              |               |
              1               4
              |               |
          ---- ----       ---- ----
         |         |     |         |
         6         5     2         7
         |
     ----
    |
    8

    x = 2

    =>

    3,4,2

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`Makefile, program.cpp, BinaryTree.hpp, posInTree.hpp`. Us falta crear
el fitxer `posInTree.cpp` amb els corresponents `includes` i
implementar-hi la funció anterior. Quan pugeu la vostra solució al
jutge, només cal que pugeu un tar construït així:


    tar cf solution.tar posInTree.cpp

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre
binari d'enters sense elements repetits `t`, i un enter `x`. Fixeu-vos
en que el programa que us oferim ja s'encarrega de llegir aquestes
entrades. Només cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté una línia amb la llista dels elements
que es troben en el camí des de l'arrel fins la posició de `x` a `t`. La
línia és buida si `x` no hi és a `t`. Fixeu-vos en que el programa que
us oferim ja s'encarrega d'escriure aquestes dades. Només cal que
implementeu la funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema. En les
crides recursives, incloeu la hipòtesi d'inducció, és a dir una
explicació del que es cumpleix després de la crida, i també la funció de
fita/decreixement o una justificació de perquè la funció recursiva
acaba.

Molt possiblement, una solució directa serà lenta, i necessitareu crear
alguna funció recursiva auxiliar per a produïr una solució més eficient
capaç de superar tots els jocs de proves.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T20:36:30.272Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
