#include <iostream>
#include <queue>
using namespace std;

/**
 * @pre c contiene la sucesión de enteros que representan los números de items de los clientes que
 * quieren pasar por las cajas, y num_cajas es el número de cajas abiertas. Se supone que todos los
 * clientes tienen más de un item para pagar.
 *
 * @post se devuelve el mínimo tiempo necesario para que todos hayan pasado por caja.
 *
 */
int punto_verde(int num_emp, queue<int>& c);

template <typename T>
T read() {
	T n;
	cin >> n;
	return n;
}

template <typename T>
queue<T> read_queue() {
	int n = read<int>();
	queue<T> q;
	for (int i = 0; i < n; i++) {
		q.push(read<T>());
	}
	return q;
}

int main() {
	int num_cases = read<int>();
	for (int i = 0; i < num_cases; ++i) {
		int num_emp = read<int>();
		auto q = read_queue<int>();
		cout << punto_verde(num_emp, q) << endl;
	}
	return 0;
}
