# Llista equilibrada recursiva

Una llista d'enters és **equilibrada** si algun element de la llista
compleix que la suma dels seus predecessors és igual a la suma dels seus
successors.

Per exemple, la llista $l=[-5, 6, 2, 3, 4, 0, 5, 1]$ és equilibrada ja
que el $4$ compleix que $-5+6+2+3 = 0+5+1$.

Implementa una funció **RECURSIVA** que donada un llista d'enters torna
cert si la llista és equilibrada i fals altrament.

## Interfície

La capçalera de la funció és la següent:

    // Pre: cert
    // Post: retorna cert si la llista té algun element que compleix que la suma
    // dels seus predecessors és igual a la suma dels seus successors; fals altrament
    bool llista_equilibrada(const list<int> &l)

 

## Observació

La funció i subfuncions que creïs han de treballar només amb llistes (la
classe `list` de la biblioteca STL). Has de trobar una solució
**RECURSIVA** i eficient del problema. En particular, no hi hauria
d'haver cap bucle en cap de les funcions que implementis. Si crees
funcions auxiliars, afegeix-hi les corresponents **Precondició** (Pre) i
**Postcondició** (Post). En les crides recursives inclou la **hipòtesi
d'inducció** (HI) i la **funció de fita** (FF).

**IMPORTANT**: Només cal enviar el procediment demanat; el programa
principal serà ignorat.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T13:36:27.883Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
