# Práctica de PRO2 - Primavera 2019 - entrega provisional

Este problema permite hacer entregas de prueba de la práctica completa.
Tened en cuenta que:

- no es el canal para hacer la entrega definitiva de la práctica

- el problema del Jutge de la entrega definitiva puede contener
  elementos o condiciones diferentes de los que aparecen en este
  problema

- las entregas realizadas en este problema no serán tenidas en cuenta
  para la nota de la práctica

- en esta entrega no pedimos carpetas generadas mediante `doxygen`, pero
  los ficheros de la clases pueden llevar todos los comentarios
  `doxygen` que queráis; de hecho recomendamos que incluyáis las
  especificaciones de todas las operaciones y que sean lo más
  definitivas posible

## Entrada

Una secuencia de instrucciones y datos que siguen el formato del
enunciado de la práctica y del juego de pruebas público.

## Salida

Una secuencia de resultados que siguen el formato del enunciado de la
práctica y del juego de pruebas público.

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: combinación de los juegos de pruebas de la entrega intermedia

- privat2: juego de pruebas que explora situaciones de las tres
  funcionalidades que no aparecen en la entrega intermedia (codificar,
  decodificar, añadir/actualizar idioma), sin controlar la eficiencia

- privat3: juego de pruebas que hace énfasis en la eficiencia de las
  tres funcionalidades que no aparecen en la entrega intemedia

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros .hh y .cc de las clases y el programa principal

- El fichero Makefile, que usaremos para generar y probar el ejecutable

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El Makefile ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciréis el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PR02

Generación: 2026-01-25T20:36:20.967Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
