# Cifrado con diferentes avances

Escribe una función llamada `cifrar_avances`. Dicha función recibirá un
parámetro de tipo cadena de caracteres y otro de tipo entero. La función
debe devolver una cadena de caracteres.

La función deberá cifrar la cadena de caracteres de entrada usando el
mecanismo que se vio en prácticas. Cada carácter del mensaje de entrada
se sustituirá por otro carácter que obtendremos al avanzar en el
alfabeto un número determinado de posiciones. Si decidimos que vamos a
adelantar dos posiciones, el carácter "`a`" se convertirá en "`c`", el
carácter "`b`" se convertirá en "`d`", etc.

Para avanzar en el alfabeto, haremos servir las funciones `ord` y `chr`
vistas en clase. La función `ord` recibe un parámetro de tipo carácter y
devuelve su código Unicode, es decir, un número entero positivo que lo
identifica. Dichos códigos siguen generalmente el orden alfabético. La
función `chr` recibe un parámetro de tipo entero y devuelve el carácter
asociado al código Unicode pasado como parámetro.

Para cifrar una cadena, por cada carácter de la cadena original, debemos
obtener su código Unicode con `ord`, sumarle el incremento
correspondiente, obtener el carácter cifrado con `chr` y añadirlo a la
cadena cifrada.

IMPORTANTE: el incremento a utilizar será el segundo parámetro de la
función, excepto si el carácer a cifrar es una vocal en minúsculas sin
acentuar (es decir, un miembro del conjunto "`aeiou`"). En ese caso,
será el valor de dicho parámetro multiplicado por dos.

Por ejemplo, si ciframos la cadena "`casa`" pasamos el valor `3` como
segundo parámetro, el resultado será "`fgvg`" porque habremos
incrementado la "`c`" y la "`s`" en 3 posiciones, y la "`a`" en 6
posiciones.

Para que tu función pueda ser evaluada correctamente por el juez en
línea, tu código deberá tener la siguiente forma:

``` python
import sys

def cifra_avances(cad,avance):
...

c=sys.stdin.readline().strip()
a=int(sys.stdin.readline().strip())
resultado=cifra_avances(c,a)
print(resultado)
```

## Entrada

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) La primera línea contendrá la cadena a cifrar y,
la segunda, el avance a emplear.

## Salida

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) La cadena cifrada.

## Información del problema

Autoría: Víctor M. Sánchez Cartagena

Generación: 2026-01-25T18:38:43.674Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
